/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.json;

import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.json.DataObjectFactoryUtil;
import twitter4jads.internal.json.ResponseListImpl;
import twitter4jads.internal.json.TwitterResponseImpl;
import twitter4jads.internal.json.z_T4JInternalParseUtil;
import twitter4jads.internal.models4j.Location;
import twitter4jads.internal.models4j.ResponseList;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.org.json.JSONArray;
import twitter4jads.internal.org.json.JSONException;
import twitter4jads.internal.org.json.JSONObject;

public final class LocationJSONImpl
extends TwitterResponseImpl
implements Location {
    private final int woeid;
    private final String countryName;
    private final String countryCode;
    private final String placeName;
    private final int placeCode;
    private final String name;
    private final String url;
    private static final long serialVersionUID = 7095092358530897222L;

    public LocationJSONImpl(JSONObject location) throws TwitterException {
        super(location);
        try {
            this.woeid = z_T4JInternalParseUtil.getInt("woeid", location);
            this.countryName = z_T4JInternalParseUtil.getUnescapedString("country", location);
            this.countryCode = z_T4JInternalParseUtil.getRawString("countryCode", location);
            if (!location.isNull("placeType")) {
                JSONObject placeJSON = location.getJSONObject("placeType");
                this.placeName = z_T4JInternalParseUtil.getUnescapedString("name", placeJSON);
                this.placeCode = z_T4JInternalParseUtil.getInt("code", placeJSON);
            } else {
                this.placeName = null;
                this.placeCode = -1;
            }
            this.name = z_T4JInternalParseUtil.getUnescapedString("name", location);
            this.url = z_T4JInternalParseUtil.getUnescapedString("url", location);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    static ResponseList<Location> createLocationList(HttpResponse res, Configuration conf) throws TwitterException {
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
        }
        return LocationJSONImpl.createLocationList(res.asJSONArray(), conf.isJSONStoreEnabled());
    }

    static ResponseList<Location> createLocationList(JSONArray list, boolean storeJSON) throws TwitterException {
        try {
            int size = list.length();
            ResponseListImpl<Location> locations = new ResponseListImpl<Location>(size, null);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                LocationJSONImpl location = new LocationJSONImpl(json);
                locations.add(location);
                if (!storeJSON) continue;
                DataObjectFactoryUtil.registerJSONObject(location, json);
            }
            if (storeJSON) {
                DataObjectFactoryUtil.registerJSONObject(locations, list);
            }
            return locations;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    @Override
    public int getWoeid() {
        return this.woeid;
    }

    @Override
    public String getCountryName() {
        return this.countryName;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getPlaceName() {
        return this.placeName;
    }

    @Override
    public int getPlaceCode() {
        return this.placeCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationJSONImpl)) {
            return false;
        }
        LocationJSONImpl that = (LocationJSONImpl)o;
        return this.woeid == that.woeid;
    }

    public int hashCode() {
        return this.woeid;
    }

    public String toString() {
        return "LocationJSONImpl{woeid=" + this.woeid + ", countryName='" + this.countryName + '\'' + ", countryCode='" + this.countryCode + '\'' + ", placeName='" + this.placeName + '\'' + ", placeCode='" + this.placeCode + '\'' + ", name='" + this.name + '\'' + ", url='" + this.url + '\'' + '}';
    }
}

