/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import twitter4jads.internal.json.EntityIndex;
import twitter4jads.internal.json.z_T4JInternalParseUtil;
import twitter4jads.internal.models4j.MediaEntity;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.org.json.JSONArray;
import twitter4jads.internal.org.json.JSONException;
import twitter4jads.internal.org.json.JSONObject;

public class MediaEntityJSONImpl
extends EntityIndex
implements MediaEntity {
    private static final long serialVersionUID = 224487082931268487L;
    private long id;
    private String url;
    private String mediaURL;
    private String mediaURLHttps;
    private String expandedURL;
    private String displayURL;
    private Map<Integer, MediaEntity.Size> sizes;
    private String type;
    private MediaEntity.VideoInfo videoInfo;

    MediaEntityJSONImpl(JSONObject json) throws TwitterException {
        try {
            JSONArray indicesArray = json.getJSONArray("indices");
            this.setStart(indicesArray.getInt(0));
            this.setEnd(indicesArray.getInt(1));
            this.id = z_T4JInternalParseUtil.getLong("id", json);
            this.url = json.getString("url");
            this.expandedURL = json.getString("expanded_url");
            this.mediaURL = json.getString("media_url");
            this.mediaURLHttps = json.getString("media_url_https");
            this.displayURL = json.getString("display_url");
            JSONObject sizes = json.getJSONObject("sizes");
            this.sizes = new HashMap<Integer, MediaEntity.Size>(4);
            this.addMediaEntitySizeIfNotNull(this.sizes, sizes, MediaEntity.Size.LARGE, "large");
            this.addMediaEntitySizeIfNotNull(this.sizes, sizes, MediaEntity.Size.MEDIUM, "medium");
            this.addMediaEntitySizeIfNotNull(this.sizes, sizes, MediaEntity.Size.SMALL, "small");
            this.addMediaEntitySizeIfNotNull(this.sizes, sizes, MediaEntity.Size.THUMB, "thumb");
            if (!json.isNull("type")) {
                this.type = json.getString("type");
            }
            if (json.has("video_info")) {
                JSONObject videoInfoJSONObject = json.getJSONObject("video_info");
                this.videoInfo = new VideoInfoImpl(videoInfoJSONObject);
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    private void addMediaEntitySizeIfNotNull(Map<Integer, MediaEntity.Size> sizes, JSONObject sizesJSON, Integer size, String key) throws JSONException {
        if (!sizesJSON.isNull(key)) {
            sizes.put(size, new Size(sizesJSON.getJSONObject(key)));
        }
    }

    MediaEntityJSONImpl() {
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getMediaURL() {
        return this.mediaURL;
    }

    @Override
    public String getMediaURLHttps() {
        return this.mediaURLHttps;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getDisplayURL() {
        return this.displayURL;
    }

    @Override
    public String getExpandedURL() {
        return this.expandedURL;
    }

    @Override
    public Map<Integer, MediaEntity.Size> getSizes() {
        return this.sizes;
    }

    @Override
    public MediaEntity.VideoInfo getVideoInfo() {
        return this.videoInfo;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getStart() {
        return super.getStart();
    }

    @Override
    public int getEnd() {
        return super.getEnd();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaEntityJSONImpl)) {
            return false;
        }
        MediaEntityJSONImpl that = (MediaEntityJSONImpl)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "MediaEntityJSONImpl{id=" + this.id + ", url=" + this.url + ", mediaURL=" + this.mediaURL + ", mediaURLHttps=" + this.mediaURLHttps + ", expandedURL=" + this.expandedURL + ", displayURL='" + this.displayURL + '\'' + ", sizes=" + this.sizes + ", type=" + this.type + '}';
    }

    static class VariantImpl
    implements MediaEntity.Variant {
        String contentType;
        String url;
        Long bitrate;

        @Override
        public Long getbitrate() {
            return this.bitrate;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        VariantImpl(JSONObject json) throws JSONException {
            if (json.has("content_type")) {
                this.contentType = json.getString("content_type");
            }
            if (json.has("url")) {
                this.url = json.getString("url");
            }
            if (json.has("bitrate")) {
                this.bitrate = json.getLong("bitrate");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariantImpl variantImpl = (VariantImpl)o;
            if (this.contentType != null ? !this.contentType.equals(variantImpl.contentType) : variantImpl.contentType != null) {
                return false;
            }
            if (this.url != null ? !this.url.equals(variantImpl.url) : variantImpl.url != null) {
                return false;
            }
            return !(this.bitrate == null ? variantImpl.bitrate != null : !this.bitrate.equals(variantImpl.bitrate));
        }

        public int hashCode() {
            int result = this.contentType != null ? this.contentType.hashCode() : 0;
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            result = 31 * result + (this.bitrate != null ? this.bitrate.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "VariantImpl{contentType='" + this.contentType + '\'' + ", url='" + this.url + '\'' + ", bitrate=" + this.bitrate + '}';
        }
    }

    static class VideoInfoImpl
    implements MediaEntity.VideoInfo {
        List<Integer> aspectRatio = new ArrayList<Integer>();
        List<MediaEntity.Variant> variants = new ArrayList<MediaEntity.Variant>();
        Long millis;

        VideoInfoImpl(JSONObject jsonObject) throws TwitterException {
            try {
                int i;
                if (jsonObject.has("aspect_ratio")) {
                    JSONArray aspectRationArray = jsonObject.getJSONArray("aspect_ratio");
                    for (i = 0; i < aspectRationArray.length(); ++i) {
                        this.aspectRatio.add(aspectRationArray.getInt(i));
                    }
                }
                if (jsonObject.has("duration_millis")) {
                    this.millis = jsonObject.getLong("duration_millis");
                }
                if (jsonObject.has("variants")) {
                    JSONArray variantJSONArray = jsonObject.getJSONArray("variants");
                    for (i = 0; i < variantJSONArray.length(); ++i) {
                        this.variants.add(new VariantImpl(variantJSONArray.getJSONObject(i)));
                    }
                }
            }
            catch (JSONException e) {
                throw new TwitterException(e);
            }
        }

        @Override
        public List<Integer> getAspectRatio() {
            return this.aspectRatio;
        }

        @Override
        public Long getMillis() {
            return this.millis;
        }

        public void setMillis(Long millis) {
            this.millis = millis;
        }

        @Override
        public List<MediaEntity.Variant> getVariants() {
            return this.variants;
        }
    }

    static class Size
    implements MediaEntity.Size {
        private static final long serialVersionUID = 8681853416159361581L;
        int width;
        int height;
        int resize;

        Size(JSONObject json) throws JSONException {
            this.width = json.getInt("w");
            this.height = json.getInt("h");
            this.resize = "fit".equals(json.getString("resize")) ? 100 : 101;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public int getResize() {
            return this.resize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Size)) {
                return false;
            }
            Size size = (Size)o;
            if (this.height != size.height) {
                return false;
            }
            if (this.resize != size.resize) {
                return false;
            }
            return this.width == size.width;
        }

        public int hashCode() {
            int result = this.width;
            result = 31 * result + this.height;
            result = 31 * result + this.resize;
            return result;
        }

        public String toString() {
            return "Size{width=" + this.width + ", height=" + this.height + ", resize=" + this.resize + '}';
        }
    }
}

