/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.json;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.json.DataObjectFactoryUtil;
import twitter4jads.internal.json.HTMLEntity;
import twitter4jads.internal.json.HashtagEntityJSONImpl;
import twitter4jads.internal.json.MediaEntityJSONImpl;
import twitter4jads.internal.json.PlaceJSONImpl;
import twitter4jads.internal.json.ResponseListImpl;
import twitter4jads.internal.json.TwitterResponseImpl;
import twitter4jads.internal.json.URLEntityJSONImpl;
import twitter4jads.internal.json.UserJSONImpl;
import twitter4jads.internal.json.UserMentionEntityJSONImpl;
import twitter4jads.internal.json.z_T4JInternalJSONImplFactory;
import twitter4jads.internal.json.z_T4JInternalParseUtil;
import twitter4jads.internal.logging.Logger;
import twitter4jads.internal.models4j.GeoLocation;
import twitter4jads.internal.models4j.HashtagEntity;
import twitter4jads.internal.models4j.JSONResponse;
import twitter4jads.internal.models4j.MediaEntity;
import twitter4jads.internal.models4j.Place;
import twitter4jads.internal.models4j.ResponseList;
import twitter4jads.internal.models4j.Status;
import twitter4jads.internal.models4j.TweetScope;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.models4j.URLEntity;
import twitter4jads.internal.models4j.User;
import twitter4jads.internal.models4j.UserMentionEntity;
import twitter4jads.internal.org.json.JSONArray;
import twitter4jads.internal.org.json.JSONException;
import twitter4jads.internal.org.json.JSONObject;

public final class StatusJSONImpl
extends TwitterResponseImpl
implements Status,
Serializable,
JSONResponse {
    private static final Logger logger = Logger.getLogger(StatusJSONImpl.class);
    private static final long serialVersionUID = 7548618898682727465L;
    private Date createdAt;
    private long id;
    private String idStr;
    private String inReplyToUserIdStr;
    private String inReplyToStatusIdStr;
    private String text;
    private String actualText;
    private String fullText;
    private String[] displayTextRange;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private long inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private GeoLocation geoLocation = null;
    private Place place = null;
    private long retweetCount;
    private long favoriteCount;
    private boolean isPossiblySensitive;
    private long[] contributorsIDs;
    private Status retweetedStatus;
    private Status quotedStatus;
    private Status extendedTweet;
    private long quotedStatusId;
    private String quotedStatusIdStr;
    private UserMentionEntity[] userMentionEntities;
    private URLEntity[] urlEntities;
    private HashtagEntity[] hashtagEntities;
    private MediaEntity[] mediaEntities;
    private MediaEntity[] extendedMediaEntities;
    private long currentUserRetweetId = -1L;
    private String[] placeIds;
    private TweetScope scopes;
    private String language;
    private String cardUri;
    private Boolean hierarchicalMessage = false;
    private String hierarchicalMessageId;
    private User user = null;

    StatusJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        this.init(this.getJSONObject());
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, this.getJSONObject());
        }
    }

    StatusJSONImpl(JSONObject json, Configuration conf) throws TwitterException {
        super(json);
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    public StatusJSONImpl(JSONObject json) throws TwitterException {
        super(json);
        this.init(json);
    }

    StatusJSONImpl() {
    }

    public static ResponseList<Status> createStatusList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseListImpl<Status> statuses = new ResponseListImpl<Status>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                StatusJSONImpl status = new StatusJSONImpl(json);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(status, json);
                }
                statuses.add(status);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(statuses, list);
            }
            return statuses;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public static ResponseList<Status> parseStatuses(Configuration conf, JSONArray list) throws JSONException, TwitterException {
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
        }
        int size = list.length();
        ResponseListImpl<Status> statuses = new ResponseListImpl<Status>(size, null);
        for (int i = 0; i < size; ++i) {
            JSONObject json = list.getJSONObject(i);
            StatusJSONImpl status = new StatusJSONImpl(json);
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(status, json);
            }
            statuses.add(status);
        }
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject(statuses, list);
        }
        return statuses;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getFullText() {
        return this.fullText;
    }

    @Override
    public String[] getDisplayTextRange() {
        return this.displayTextRange;
    }

    @Override
    public Status getExtendedTweet() {
        return this.extendedTweet;
    }

    @Override
    public String getText() {
        return this.actualText;
    }

    @Override
    public String getUnEscapedText() {
        return this.text;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isTruncated() {
        return this.isTruncated;
    }

    @Override
    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    @Override
    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    @Override
    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    @Override
    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public long[] getContributors() {
        return this.contributorsIDs;
    }

    @Override
    public boolean isFavorited() {
        return this.isFavorited;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public boolean isRetweet() {
        return this.retweetedStatus != null;
    }

    @Override
    public Status getRetweetedStatus() {
        return this.retweetedStatus;
    }

    @Override
    public Status getQuotedStatus() {
        return this.quotedStatus;
    }

    @Override
    public long getQuotedStatusId() {
        return this.quotedStatusId;
    }

    @Override
    public String getQuotedStatusIdStr() {
        return this.quotedStatusIdStr;
    }

    @Override
    public long getRetweetCount() {
        return this.retweetCount;
    }

    @Override
    public long getFavoriteCount() {
        return this.favoriteCount;
    }

    @Override
    public boolean isRetweetedByMe() {
        return this.currentUserRetweetId != -1L;
    }

    @Override
    public long getCurrentUserRetweetId() {
        return this.currentUserRetweetId;
    }

    @Override
    public boolean isPossiblySensitive() {
        return this.isPossiblySensitive;
    }

    @Override
    public UserMentionEntity[] getUserMentionEntities() {
        return this.userMentionEntities;
    }

    @Override
    public URLEntity[] getURLEntities() {
        return this.urlEntities;
    }

    @Override
    public HashtagEntity[] getHashtagEntities() {
        return this.hashtagEntities;
    }

    @Override
    public MediaEntity[] getMediaEntities() {
        return this.mediaEntities;
    }

    @Override
    public MediaEntity[] getExtendedMediaEntities() {
        return this.extendedMediaEntities;
    }

    @Override
    public String[] getPlaceIds() {
        return this.placeIds;
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = z_T4JInternalParseUtil.getLong("id", json);
        this.idStr = z_T4JInternalParseUtil.getRawString("id_str", json);
        this.source = z_T4JInternalParseUtil.getUnescapedString("source", json);
        this.createdAt = z_T4JInternalParseUtil.getDate("created_at", json);
        this.isTruncated = z_T4JInternalParseUtil.getBoolean("truncated", json);
        this.inReplyToStatusId = z_T4JInternalParseUtil.getLong("in_reply_to_status_id", json);
        this.inReplyToStatusIdStr = z_T4JInternalParseUtil.getRawString("in_reply_to_status_id_str", json);
        this.quotedStatusId = z_T4JInternalParseUtil.getLong("quoted_status_id", json);
        this.quotedStatusIdStr = z_T4JInternalParseUtil.getRawString("quoted_status_id_str", json);
        this.inReplyToUserId = z_T4JInternalParseUtil.getLong("in_reply_to_user_id", json);
        this.inReplyToUserIdStr = z_T4JInternalParseUtil.getRawString("in_reply_to_user_id_str", json);
        this.isFavorited = z_T4JInternalParseUtil.getBoolean("favorited", json);
        this.inReplyToScreenName = z_T4JInternalParseUtil.getUnescapedString("in_reply_to_screen_name", json);
        this.retweetCount = z_T4JInternalParseUtil.getLong("retweet_count", json);
        this.favoriteCount = z_T4JInternalParseUtil.getLong("favorite_count", json);
        this.isPossiblySensitive = z_T4JInternalParseUtil.getBoolean("possibly_sensitive", json);
        try {
            int len;
            JSONObject entities;
            int i;
            JSONObject scopes;
            if (!json.isNull("user")) {
                this.user = new UserJSONImpl(json.getJSONObject("user"));
            }
            this.geoLocation = z_T4JInternalJSONImplFactory.createGeoLocation(json);
            if (!json.isNull("place")) {
                this.place = new PlaceJSONImpl(json.getJSONObject("place"));
            }
            if (!json.isNull("retweeted_status")) {
                this.retweetedStatus = new StatusJSONImpl(json.getJSONObject("retweeted_status"));
            }
            if (!json.isNull("quoted_status")) {
                this.quotedStatus = new StatusJSONImpl(json.getJSONObject("quoted_status"));
            }
            if (!json.isNull("contributors")) {
                JSONArray contributorsArray = json.getJSONArray("contributors");
                this.contributorsIDs = new long[contributorsArray.length()];
                for (int i2 = 0; i2 < contributorsArray.length(); ++i2) {
                    this.contributorsIDs[i2] = Long.parseLong(contributorsArray.getString(i2));
                }
            } else {
                this.contributorsIDs = new long[0];
            }
            this.language = z_T4JInternalParseUtil.getRawString("lang", json);
            if (!json.isNull("scopes") && !(scopes = json.getJSONObject("scopes")).isNull("place_ids")) {
                JSONArray placeIdArray = scopes.getJSONArray("place_ids");
                int len2 = placeIdArray.length();
                this.placeIds = new String[len2];
                for (i = 0; i < len2; ++i) {
                    this.placeIds[i] = placeIdArray.getString(i);
                }
            }
            if (!json.isNull("entities")) {
                entities = json.getJSONObject("entities");
                if (!entities.isNull("user_mentions")) {
                    JSONArray userMentionsArray = entities.getJSONArray("user_mentions");
                    len = userMentionsArray.length();
                    this.userMentionEntities = new UserMentionEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.userMentionEntities[i] = new UserMentionEntityJSONImpl(userMentionsArray.getJSONObject(i));
                    }
                }
                if (!entities.isNull("urls")) {
                    JSONArray urlsArray = entities.getJSONArray("urls");
                    len = urlsArray.length();
                    this.urlEntities = new URLEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.urlEntities[i] = new URLEntityJSONImpl(urlsArray.getJSONObject(i));
                    }
                }
                if (!entities.isNull("hashtags")) {
                    JSONArray hashtagsArray = entities.getJSONArray("hashtags");
                    len = hashtagsArray.length();
                    this.hashtagEntities = new HashtagEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.hashtagEntities[i] = new HashtagEntityJSONImpl(hashtagsArray.getJSONObject(i));
                    }
                }
                if (!entities.isNull("media")) {
                    JSONArray mediaArray = entities.getJSONArray("media");
                    len = mediaArray.length();
                    this.mediaEntities = new MediaEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.mediaEntities[i] = new MediaEntityJSONImpl(mediaArray.getJSONObject(i));
                    }
                }
            }
            if (!json.isNull("extended_entities") && !(entities = json.getJSONObject("extended_entities")).isNull("media")) {
                JSONArray mediaArray = entities.getJSONArray("media");
                len = mediaArray.length();
                this.extendedMediaEntities = new MediaEntity[len];
                for (i = 0; i < len; ++i) {
                    this.extendedMediaEntities[i] = new MediaEntityJSONImpl(mediaArray.getJSONObject(i));
                }
            }
            if (!json.isNull("display_text_range")) {
                JSONArray displayTextRangeArray = json.getJSONArray("display_text_range");
                len = displayTextRangeArray.length();
                this.displayTextRange = new String[len];
                for (int i3 = 0; i3 < len; ++i3) {
                    this.displayTextRange[i3] = displayTextRangeArray.getString(i3);
                }
            }
            this.userMentionEntities = this.userMentionEntities == null ? new UserMentionEntity[]{} : this.userMentionEntities;
            this.urlEntities = this.urlEntities == null ? new URLEntity[]{} : this.urlEntities;
            this.hashtagEntities = this.hashtagEntities == null ? new HashtagEntity[]{} : this.hashtagEntities;
            this.mediaEntities = this.mediaEntities == null ? new MediaEntity[]{} : this.mediaEntities;
            this.extendedMediaEntities = this.extendedMediaEntities == null ? this.mediaEntities : this.extendedMediaEntities;
            this.fullText = z_T4JInternalParseUtil.getRawString("full_text", json);
            this.actualText = z_T4JInternalParseUtil.getRawString("text", json);
            if (this.fullText != null) {
                this.actualText = this.fullText;
            }
            if (!json.isNull("current_user_retweet")) {
                this.currentUserRetweetId = json.getJSONObject("current_user_retweet").getLong("id");
            }
            if (!json.isNull("extended_tweet")) {
                String extendedTweetText;
                this.extendedTweet = new StatusJSONImpl(json.getJSONObject("extended_tweet"));
                String string = extendedTweetText = StringUtils.isNotEmpty((CharSequence)this.extendedTweet.getFullText()) ? this.extendedTweet.getFullText() : this.extendedTweet.getText();
                if (this.extendedTweet != null && StringUtils.isNotEmpty((CharSequence)extendedTweetText)) {
                    this.actualText = this.extendedTweet.getFullText();
                    this.userMentionEntities = this.extendedTweet.getUserMentionEntities();
                    this.urlEntities = this.extendedTweet.getURLEntities();
                    this.hashtagEntities = this.extendedTweet.getHashtagEntities();
                    this.mediaEntities = this.extendedTweet.getMediaEntities();
                    this.extendedMediaEntities = this.extendedTweet.getExtendedMediaEntities();
                }
            }
            this.text = HTMLEntity.unescapeAndSlideEntityIncdices(this.actualText, this.userMentionEntities, this.urlEntities, this.hashtagEntities, this.mediaEntities);
            if (!json.isNull("card_uri")) {
                this.cardUri = json.getString("card_uri");
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public int compareTo(Status that) {
        long delta = this.id - that.getId();
        if (delta < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (delta > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)delta;
    }

    public void setPlaceIds(String[] placeIds) {
        this.placeIds = placeIds;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).getId() == this.id;
    }

    @Override
    public String getIdStr() {
        return this.idStr;
    }

    @Override
    public String getInReplyToUserIdStr() {
        return this.inReplyToUserIdStr;
    }

    @Override
    public String getInReplyToStatusIdStr() {
        return this.inReplyToStatusIdStr;
    }

    @Override
    public TweetScope getScopes() {
        return this.scopes;
    }

    public void setScopes(TweetScope scopes) {
        this.scopes = scopes;
    }

    @Override
    public Boolean getHierarchicalMessage() {
        return this.hierarchicalMessage;
    }

    @Override
    public void setHierarchicalMessage(Boolean hierarchicalMessage) {
        this.hierarchicalMessage = hierarchicalMessage;
    }

    @Override
    public String getHierarchicalMessageId() {
        return this.hierarchicalMessageId;
    }

    @Override
    public void setHierarchicalMessageId(String statusId) {
        this.hierarchicalMessageId = statusId;
    }

    @Override
    public String getCardUri() {
        return this.cardUri;
    }

    public void setCardUri(String cardUri) {
        this.cardUri = cardUri;
    }

    public String toString() {
        return "StatusJSONImpl{createdAt=" + this.createdAt + ", id=" + this.id + ", idStr='" + this.idStr + '\'' + ", inReplyToUserIdStr='" + this.inReplyToUserIdStr + '\'' + ", inReplyToStatusIdStr='" + this.inReplyToStatusIdStr + '\'' + ", text='" + this.text + '\'' + ", actualText='" + this.actualText + '\'' + ", fullText='" + this.fullText + '\'' + ", displayTextRange=" + Arrays.toString(this.displayTextRange) + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", geoLocation=" + this.geoLocation + ", place=" + this.place + ", retweetCount=" + this.retweetCount + ", favoriteCount=" + this.favoriteCount + ", isPossiblySensitive=" + this.isPossiblySensitive + ", contributorsIDs=" + Arrays.toString(this.contributorsIDs) + ", retweetedStatus=" + this.retweetedStatus + ", quotedStatus=" + this.quotedStatus + ", extendedTweet=" + this.extendedTweet + ", quotedStatusId=" + this.quotedStatusId + ", quotedStatusIdStr='" + this.quotedStatusIdStr + '\'' + ", userMentionEntities=" + Arrays.toString(this.userMentionEntities) + ", urlEntities=" + Arrays.toString(this.urlEntities) + ", hashtagEntities=" + Arrays.toString(this.hashtagEntities) + ", mediaEntities=" + Arrays.toString(this.mediaEntities) + ", extendedMediaEntities=" + Arrays.toString(this.extendedMediaEntities) + ", currentUserRetweetId=" + this.currentUserRetweetId + ", placeIds=" + Arrays.toString(this.placeIds) + ", scopes=" + this.scopes + ", language='" + this.language + '\'' + ", cardUri='" + this.cardUri + '\'' + ", hierarchicalMessage=" + this.hierarchicalMessage + ", hierarchicalMessageId='" + this.hierarchicalMessageId + '\'' + ", user=" + this.user + '}';
    }
}

