/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.json;

import java.io.Serializable;
import twitter4jads.internal.json.DataObjectFactoryUtil;
import twitter4jads.internal.json.z_T4JInternalParseUtil;
import twitter4jads.internal.models4j.JSONResponseImpl;
import twitter4jads.internal.models4j.Trend;
import twitter4jads.internal.org.json.JSONObject;

public final class TrendJSONImpl
extends JSONResponseImpl
implements Trend,
Serializable {
    private String name;
    private String url = null;
    private String query = null;
    private Integer tweetVolume = null;
    private static final long serialVersionUID = 1925956704460743946L;

    TrendJSONImpl(JSONObject json, boolean storeJSON) {
        super(json);
        this.name = z_T4JInternalParseUtil.getRawString("name", json);
        this.url = z_T4JInternalParseUtil.getRawString("url", json);
        this.query = z_T4JInternalParseUtil.getRawString("query", json);
        this.tweetVolume = z_T4JInternalParseUtil.getInt("tweet_volume", json);
        if (storeJSON) {
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    TrendJSONImpl(JSONObject json) {
        this(json, false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.getURL();
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public Integer getTweetVolume() {
        return this.tweetVolume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trend)) {
            return false;
        }
        Trend trend = (Trend)o;
        if (!this.name.equals(trend.getName())) {
            return false;
        }
        if (this.query != null ? !this.query.equals(trend.getQuery()) : trend.getQuery() != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(trend.getURL()) : trend.getURL() != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TrendJSONImpl{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", query='" + this.query + '\'' + '}';
    }
}

