/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.json;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.json.DataObjectFactoryUtil;
import twitter4jads.internal.json.LocationJSONImpl;
import twitter4jads.internal.json.RateLimitStatusJSONImpl;
import twitter4jads.internal.json.ResponseListImpl;
import twitter4jads.internal.json.TrendJSONImpl;
import twitter4jads.internal.json.TwitterResponseImpl;
import twitter4jads.internal.json.z_T4JInternalParseUtil;
import twitter4jads.internal.models4j.Location;
import twitter4jads.internal.models4j.RateLimitStatus;
import twitter4jads.internal.models4j.ResponseList;
import twitter4jads.internal.models4j.Trend;
import twitter4jads.internal.models4j.Trends;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.org.json.JSONArray;
import twitter4jads.internal.org.json.JSONException;
import twitter4jads.internal.org.json.JSONObject;

final class TrendsJSONImpl
extends TwitterResponseImpl
implements Trends,
Serializable {
    private Date asOf;
    private Date trendAt;
    private Trend[] trends;
    private Location location;
    private static final long serialVersionUID = -7151479143843312309L;
    private transient JSONObject json;
    private transient RateLimitStatus rateLimitStatus = null;
    private transient int accessLevel;

    @Override
    public int compareTo(Trends that) {
        return this.trendAt.compareTo(that.getTrendAt());
    }

    TrendsJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super((HttpResponse)null);
        this.init(res.asString(), conf.isJSONStoreEnabled());
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, res.asString());
        }
        this.rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader(res);
        this.accessLevel = z_T4JInternalParseUtil.toAccessLevel(res);
    }

    TrendsJSONImpl(String jsonStr) throws TwitterException {
        this(jsonStr, false);
    }

    TrendsJSONImpl(String jsonStr, boolean storeJSON) throws TwitterException {
        this.init(jsonStr, storeJSON);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void init(String jsonStr, boolean storeJSON) throws TwitterException {
        try {
            JSONArray array;
            if (jsonStr.startsWith("[")) {
                array = new JSONArray(jsonStr);
                if (array.length() <= 0) throw new TwitterException("No trends found on the specified woeid");
                this.json = array.getJSONObject(0);
            } else {
                this.json = new JSONObject(jsonStr);
            }
            this.asOf = z_T4JInternalParseUtil.parseTrendsDate(this.json.getString("as_of"));
            this.location = TrendsJSONImpl.extractLocation(this.json, storeJSON);
            array = this.json.getJSONArray("trends");
            this.trendAt = this.asOf;
            this.trends = TrendsJSONImpl.jsonArrayToTrendArray(array, storeJSON);
            return;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage(), jsone);
        }
    }

    TrendsJSONImpl(Date asOf, Location location, Date trendAt, Trend[] trends) {
        this.asOf = asOf;
        this.location = location;
        this.trendAt = trendAt;
        this.trends = trends;
    }

    static ResponseList<Trends> createTrendsList(HttpResponse res, boolean storeJSON) throws TwitterException {
        JSONObject json = res.asJSONObject();
        try {
            Date asOf = z_T4JInternalParseUtil.parseTrendsDate(json.getString("as_of"));
            JSONObject trendsJson = json.getJSONObject("trends");
            Location location = TrendsJSONImpl.extractLocation(json, storeJSON);
            ResponseListImpl<Trends> trends = new ResponseListImpl<Trends>(trendsJson.length(), res);
            Iterator ite = trendsJson.keys();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                JSONArray array = trendsJson.getJSONArray(key);
                Trend[] trendsArray = TrendsJSONImpl.jsonArrayToTrendArray(array, storeJSON);
                if (key.length() == 19) {
                    trends.add(new TrendsJSONImpl(asOf, location, z_T4JInternalParseUtil.getDate(key, "yyyy-MM-dd HH:mm:ss"), trendsArray));
                    continue;
                }
                if (key.length() == 16) {
                    trends.add(new TrendsJSONImpl(asOf, location, z_T4JInternalParseUtil.getDate(key, "yyyy-MM-dd HH:mm"), trendsArray));
                    continue;
                }
                if (key.length() != 10) continue;
                trends.add(new TrendsJSONImpl(asOf, location, z_T4JInternalParseUtil.getDate(key, "yyyy-MM-dd"), trendsArray));
            }
            Collections.sort(trends);
            return trends;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + res.asString(), jsone);
        }
    }

    private static Location extractLocation(JSONObject json, boolean storeJSON) throws TwitterException {
        ResponseList<Location> locations;
        if (json.isNull("locations")) {
            return null;
        }
        try {
            locations = LocationJSONImpl.createLocationList(json.getJSONArray("locations"), storeJSON);
        }
        catch (JSONException e) {
            throw new AssertionError((Object)"locations can't be null");
        }
        Location location = 0 != locations.size() ? (Location)locations.get(0) : null;
        return location;
    }

    private static Trend[] jsonArrayToTrendArray(JSONArray array, boolean storeJSON) throws JSONException {
        Trend[] trends = new Trend[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            JSONObject trend = array.getJSONObject(i);
            trends[i] = new TrendJSONImpl(trend, storeJSON);
        }
        return trends;
    }

    @Override
    public Trend[] getTrends() {
        return this.trends;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Date getAsOf() {
        return this.asOf;
    }

    @Override
    public Date getTrendAt() {
        return this.trendAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trends)) {
            return false;
        }
        Trends trends1 = (Trends)o;
        if (this.asOf != null ? !this.asOf.equals(trends1.getAsOf()) : trends1.getAsOf() != null) {
            return false;
        }
        if (this.trendAt != null ? !this.trendAt.equals(trends1.getTrendAt()) : trends1.getTrendAt() != null) {
            return false;
        }
        return Arrays.equals(this.trends, trends1.getTrends());
    }

    public int hashCode() {
        int result = this.asOf != null ? this.asOf.hashCode() : 0;
        result = 31 * result + (this.trendAt != null ? this.trendAt.hashCode() : 0);
        result = 31 * result + (this.trends != null ? Arrays.hashCode(this.trends) : 0);
        return result;
    }

    public String toString() {
        return "TrendsJSONImpl{asOf=" + this.asOf + ", trendAt=" + this.trendAt + ", trends=" + (this.trends == null ? null : Arrays.asList(this.trends)) + '}';
    }

    @Override
    public JSONObject getJSONObject() {
        return this.json;
    }

    @Override
    public String getRawJSON() {
        if (this.json == null) {
            return null;
        }
        return this.json.toString();
    }

    @Override
    public RateLimitStatus getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    @Override
    public int getAccessLevel() {
        return this.accessLevel;
    }
}

