/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.json;

import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.json.DataObjectFactoryUtil;
import twitter4jads.internal.json.TwitterImageJSONImpl;
import twitter4jads.internal.json.TwitterResponseImpl;
import twitter4jads.internal.json.z_T4JInternalParseUtil;
import twitter4jads.internal.models4j.Image;
import twitter4jads.internal.models4j.Media;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.org.json.JSONObject;

public class TwitterUploadMediaResponseImpl
extends TwitterResponseImpl
implements Media {
    public static final String SUCCEEDED_STATE = "succeeded";
    public static final String IN_PROGRESS_STATE = "in_progress";
    public static final String PENDING = "pending";
    private Long mediaId;
    private String mediaIdString;
    private Image image;
    private Long size;
    private Long expiresAfterSecs;
    private String state;

    public Long getExpiresAfterSecs() {
        return this.expiresAfterSecs;
    }

    public void setExpiresAfterSecs(Long expiresAfterSecs) {
        this.expiresAfterSecs = expiresAfterSecs;
    }

    public TwitterUploadMediaResponseImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        this.init(this.getJSONObject());
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, this.getJSONObject());
        }
    }

    @Override
    public Long getMediaId() {
        return this.mediaId;
    }

    @Override
    public String getMediaIdString() {
        return this.mediaIdString;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public boolean isStatePending() {
        return PENDING.equalsIgnoreCase(this.state);
    }

    @Override
    public boolean isStateSucceeded() {
        return SUCCEEDED_STATE.equalsIgnoreCase(this.state);
    }

    @Override
    public boolean isStateInProgress() {
        return IN_PROGRESS_STATE.equalsIgnoreCase(this.state);
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            JSONObject processingInfo;
            this.mediaId = z_T4JInternalParseUtil.getLong("media_id", json);
            this.mediaIdString = z_T4JInternalParseUtil.getRawString("media_id", json);
            this.size = z_T4JInternalParseUtil.getLong("size", json);
            if (!json.isNull("image")) {
                this.image = new TwitterImageJSONImpl(json);
            }
            if (!json.isNull("expires_after_secs")) {
                this.expiresAfterSecs = z_T4JInternalParseUtil.getLong("expires_after_secs", json);
            }
            if (!json.isNull("processing_info") && !(processingInfo = new JSONObject(z_T4JInternalParseUtil.getRawString("processing_info", json))).isNull("state")) {
                this.state = z_T4JInternalParseUtil.getRawString("state", processingInfo);
            }
        }
        catch (Exception jsone) {
            throw new TwitterException(jsone);
        }
    }
}

