/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.json;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.json.DataObjectFactoryUtil;
import twitter4jads.internal.json.PagableResponseListImpl;
import twitter4jads.internal.json.ResponseListImpl;
import twitter4jads.internal.json.TwitterResponseImpl;
import twitter4jads.internal.json.UserJSONImpl;
import twitter4jads.internal.json.z_T4JInternalParseUtil;
import twitter4jads.internal.models4j.PagableResponseList;
import twitter4jads.internal.models4j.ResponseList;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.models4j.User;
import twitter4jads.internal.models4j.UserList;
import twitter4jads.internal.org.json.JSONArray;
import twitter4jads.internal.org.json.JSONException;
import twitter4jads.internal.org.json.JSONObject;

public class UserListJSONImpl
extends TwitterResponseImpl
implements UserList,
Serializable {
    private long id;
    private String idStr;
    private String name;
    private String fullName;
    private String slug;
    private String description;
    private int subscriberCount;
    private int memberCount;
    private String uri;
    private boolean mode;
    private User user;
    private boolean following;
    private static final long serialVersionUID = -6345893237975349030L;

    UserListJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        this.init(this.getJSONObject());
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
        }
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject(this, this.getJSONObject());
        }
    }

    public UserListJSONImpl(JSONObject json) throws TwitterException {
        super(json);
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = z_T4JInternalParseUtil.getLong("id", json);
        this.idStr = z_T4JInternalParseUtil.getRawString("id_str", json);
        this.name = z_T4JInternalParseUtil.getRawString("name", json);
        this.fullName = z_T4JInternalParseUtil.getRawString("full_name", json);
        this.slug = z_T4JInternalParseUtil.getRawString("slug", json);
        this.description = z_T4JInternalParseUtil.getRawString("description", json);
        this.subscriberCount = z_T4JInternalParseUtil.getInt("subscriber_count", json);
        this.memberCount = z_T4JInternalParseUtil.getInt("member_count", json);
        this.uri = z_T4JInternalParseUtil.getRawString("uri", json);
        this.mode = "public".equals(z_T4JInternalParseUtil.getRawString("mode", json));
        this.following = z_T4JInternalParseUtil.getBoolean("following", json);
        try {
            if (!json.isNull("user")) {
                this.user = new UserJSONImpl(json.getJSONObject("user"));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    @Override
    public int compareTo(UserList that) {
        long val = this.id - that.getId();
        if (val == 0L) {
            return 0;
        }
        return val > 0L ? 1 : -1;
    }

    @Override
    public long getId() {
        if (this.idStr != null) {
            try {
                Long idLong = Long.valueOf(this.idStr);
                if (idLong != null && this.id != idLong) {
                    this.id = idLong;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.id;
    }

    @Override
    public String getIdStr() {
        return this.idStr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getSubscriberCount() {
        return this.subscriberCount;
    }

    @Override
    public int getMemberCount() {
        return this.memberCount;
    }

    @Override
    public URI getURI() {
        try {
            return new URI(this.uri);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    @Override
    public boolean isPublic() {
        return this.mode;
    }

    @Override
    public boolean isFollowing() {
        return this.following;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    static PagableResponseList<UserList> createPagableUserListList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("lists");
            int size = list.length();
            PagableResponseListImpl users = new PagableResponseListImpl(size, json, res);
            for (int i = 0; i < size; ++i) {
                JSONObject userListJson = list.getJSONObject(i);
                UserListJSONImpl userList = new UserListJSONImpl(userListJson);
                users.add(userList);
                if (!conf.isJSONStoreEnabled()) continue;
                DataObjectFactoryUtil.registerJSONObject(userList, userListJson);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(users, json);
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    static ResponseList<UserList> createUserListList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseListImpl<UserList> users = new ResponseListImpl<UserList>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject userListJson = list.getJSONObject(i);
                UserListJSONImpl userList = new UserListJSONImpl(userListJson);
                users.add(userList);
                if (!conf.isJSONStoreEnabled()) continue;
                DataObjectFactoryUtil.registerJSONObject(userList, userListJson);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(users, list);
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return this.idStr.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof UserList && ((UserList)obj).getIdStr().equals(this.idStr);
    }

    public String toString() {
        return "UserListJSONImpl{id=" + this.id + ", name='" + this.name + '\'' + ", fullName='" + this.fullName + '\'' + ", slug='" + this.slug + '\'' + ", description='" + this.description + '\'' + ", subscriberCount=" + this.subscriberCount + ", memberCount=" + this.memberCount + ", uri='" + this.uri + '\'' + ", mode=" + this.mode + ", user=" + this.user + ", following=" + this.following + '}';
    }
}

