/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.json;

import java.util.Map;
import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.json.AccountSettingsJSONImpl;
import twitter4jads.internal.json.DirectMessageJSONImpl;
import twitter4jads.internal.json.HashtagEntityJSONImpl;
import twitter4jads.internal.json.LocationJSONImpl;
import twitter4jads.internal.json.PlaceJSONImpl;
import twitter4jads.internal.json.RateLimitStatusJSONImpl;
import twitter4jads.internal.json.RelatedResultsJSONImpl;
import twitter4jads.internal.json.ResponseListImpl;
import twitter4jads.internal.json.SimilarPlacesImpl;
import twitter4jads.internal.json.StatusJSONImpl;
import twitter4jads.internal.json.TrendsJSONImpl;
import twitter4jads.internal.json.TwitterAPIConfigurationJSONImpl;
import twitter4jads.internal.json.TwitterUploadMediaResponseImpl;
import twitter4jads.internal.json.URLEntityJSONImpl;
import twitter4jads.internal.json.UserJSONImpl;
import twitter4jads.internal.json.UserListJSONImpl;
import twitter4jads.internal.json.UserMentionEntityJSONImpl;
import twitter4jads.internal.json.z_T4JInternalFactory;
import twitter4jads.internal.models4j.AccountSettings;
import twitter4jads.internal.models4j.DirectMessage;
import twitter4jads.internal.models4j.GeoLocation;
import twitter4jads.internal.models4j.HashtagEntity;
import twitter4jads.internal.models4j.Location;
import twitter4jads.internal.models4j.Media;
import twitter4jads.internal.models4j.PagableResponseList;
import twitter4jads.internal.models4j.Place;
import twitter4jads.internal.models4j.RateLimitStatus;
import twitter4jads.internal.models4j.RelatedResults;
import twitter4jads.internal.models4j.ResponseList;
import twitter4jads.internal.models4j.SimilarPlaces;
import twitter4jads.internal.models4j.Status;
import twitter4jads.internal.models4j.Trends;
import twitter4jads.internal.models4j.TwitterAPIConfiguration;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.models4j.URLEntity;
import twitter4jads.internal.models4j.User;
import twitter4jads.internal.models4j.UserList;
import twitter4jads.internal.models4j.UserMentionEntity;
import twitter4jads.internal.org.json.JSONArray;
import twitter4jads.internal.org.json.JSONException;
import twitter4jads.internal.org.json.JSONObject;
import twitter4jads.internal.util.z_T4JInternalStringUtil;

public class z_T4JInternalJSONImplFactory
implements z_T4JInternalFactory {
    private static final long serialVersionUID = 5217622295050444866L;
    private Configuration conf;

    public z_T4JInternalJSONImplFactory(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Status createStatus(JSONObject json) throws TwitterException {
        return new StatusJSONImpl(json);
    }

    @Override
    public User createUser(JSONObject json) throws TwitterException {
        return new UserJSONImpl(json);
    }

    @Override
    public UserList createAUserList(JSONObject json) throws TwitterException {
        return new UserListJSONImpl(json);
    }

    @Override
    public DirectMessage createDirectMessage(JSONObject json) throws TwitterException {
        return new DirectMessageJSONImpl(json);
    }

    @Override
    public Map<String, RateLimitStatus> createRateLimitStatuses(HttpResponse res) throws TwitterException {
        return RateLimitStatusJSONImpl.createRateLimitStatuses(res, this.conf);
    }

    @Override
    public Status createStatus(HttpResponse res) throws TwitterException {
        return new StatusJSONImpl(res, this.conf);
    }

    @Override
    public Media createMediaUpload(HttpResponse res) throws TwitterException {
        return new TwitterUploadMediaResponseImpl(res, this.conf);
    }

    @Override
    public ResponseList<Status> createStatusList(HttpResponse res) throws TwitterException {
        return StatusJSONImpl.createStatusList(res, this.conf);
    }

    static GeoLocation createGeoLocation(JSONObject json) throws TwitterException {
        try {
            if (!json.isNull("geo")) {
                String coordinates = json.getJSONObject("geo").getString("coordinates");
                coordinates = coordinates.substring(1, coordinates.length() - 1);
                String[] point = z_T4JInternalStringUtil.split(coordinates, ",");
                return new GeoLocation(Double.parseDouble(point[0]), Double.parseDouble(point[1]));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        return null;
    }

    static GeoLocation[][] coordinatesAsGeoLocationArray(JSONArray coordinates) throws TwitterException {
        try {
            GeoLocation[][] boundingBox = new GeoLocation[coordinates.length()][];
            for (int i = 0; i < coordinates.length(); ++i) {
                JSONArray array = coordinates.getJSONArray(i);
                boundingBox[i] = new GeoLocation[array.length()];
                for (int j = 0; j < array.length(); ++j) {
                    JSONArray coordinate = array.getJSONArray(j);
                    boundingBox[i][j] = new GeoLocation(coordinate.getDouble(1), coordinate.getDouble(0));
                }
            }
            return boundingBox;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public static RateLimitStatus createRateLimitStatusFromResponseHeader(HttpResponse res) {
        return RateLimitStatusJSONImpl.createFromResponseHeader(res);
    }

    @Override
    public Trends createTrends(HttpResponse res) throws TwitterException {
        return new TrendsJSONImpl(res, this.conf);
    }

    @Override
    public User createUser(HttpResponse res) throws TwitterException {
        return new UserJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<User> createUserList(HttpResponse res) throws TwitterException {
        return UserJSONImpl.createUserList(res, this.conf);
    }

    @Override
    public ResponseList<User> createUserListFromJSONArray(HttpResponse res) throws TwitterException {
        return UserJSONImpl.createUserList(res.asJSONArray(), res, this.conf);
    }

    @Override
    public ResponseList<User> createUserListFromJSONArray_Users(HttpResponse res) throws TwitterException {
        try {
            return UserJSONImpl.createUserList(res.asJSONObject().getJSONArray("users"), res, this.conf);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public PagableResponseList<User> createPagableUserList(HttpResponse res) throws TwitterException {
        return UserJSONImpl.createPagableUserList(res, this.conf);
    }

    @Override
    public UserList createAUserList(HttpResponse res) throws TwitterException {
        return new UserListJSONImpl(res, this.conf);
    }

    @Override
    public PagableResponseList<UserList> createPagableUserListList(HttpResponse res) throws TwitterException {
        return UserListJSONImpl.createPagableUserListList(res, this.conf);
    }

    @Override
    public ResponseList<UserList> createUserListList(HttpResponse res) throws TwitterException {
        return UserListJSONImpl.createUserListList(res, this.conf);
    }

    @Override
    public DirectMessage createDirectMessage(HttpResponse res) throws TwitterException {
        return new DirectMessageJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<DirectMessage> createDirectMessageList(HttpResponse res) throws TwitterException {
        return DirectMessageJSONImpl.createDirectMessageList(res, this.conf);
    }

    @Override
    public AccountSettings createAccountSettings(HttpResponse res) throws TwitterException {
        return new AccountSettingsJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<Location> createLocationList(HttpResponse res) throws TwitterException {
        return LocationJSONImpl.createLocationList(res, this.conf);
    }

    @Override
    public Place createPlace(HttpResponse res) throws TwitterException {
        return new PlaceJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<Place> createPlaceList(HttpResponse res) throws TwitterException {
        try {
            return PlaceJSONImpl.createPlaceList(res, this.conf);
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return new ResponseListImpl<Place>(0, null);
            }
            throw te;
        }
    }

    @Override
    public SimilarPlaces createSimilarPlaces(HttpResponse res) throws TwitterException {
        return SimilarPlacesImpl.createSimilarPlaces(res, this.conf);
    }

    @Override
    public RelatedResults createRelatedResults(HttpResponse res) throws TwitterException {
        return new RelatedResultsJSONImpl(res, this.conf);
    }

    @Override
    public TwitterAPIConfiguration createTwitterAPIConfiguration(HttpResponse res) throws TwitterException {
        return new TwitterAPIConfigurationJSONImpl(res, this.conf);
    }

    @Override
    public <T> ResponseList<T> createEmptyResponseList() {
        return new ResponseListImpl(0, null);
    }

    public static HashtagEntity createHashtagEntity(int start, int end, String text) {
        return new HashtagEntityJSONImpl(start, end, text);
    }

    public static UserMentionEntity createUserMentionEntity(int start, int end, String name, String screenName, long id) {
        return new UserMentionEntityJSONImpl(start, end, name, screenName, id);
    }

    public static URLEntity createUrlEntity(int start, int end, String url, String expandedURL, String displayURL) {
        return new URLEntityJSONImpl(start, end, url, expandedURL, displayURL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof z_T4JInternalJSONImplFactory)) {
            return false;
        }
        z_T4JInternalJSONImplFactory that = (z_T4JInternalJSONImplFactory)o;
        return !(this.conf != null ? !this.conf.equals(that.conf) : that.conf != null);
    }

    public int hashCode() {
        return this.conf != null ? this.conf.hashCode() : 0;
    }

    public String toString() {
        return "JSONImplFactory{conf=" + this.conf + '}';
    }
}

