/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import twitter4jads.conf.Configuration;
import twitter4jads.conf.ConfigurationContext;
import twitter4jads.internal.logging.LoggerFactory;
import twitter4jads.internal.logging.StdOutLoggerFactory;

public abstract class Logger {
    private static final LoggerFactory LOGGER_FACTORY;
    private static final String LOGGER_FACTORY_IMPLEMENTATION = "twitter4jads.loggerFactory";

    private static LoggerFactory getLoggerFactoryIfAvailable(String checkClassName, String implementationClass) {
        try {
            Class.forName(checkClassName);
            return (LoggerFactory)Class.forName(implementationClass).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        return null;
    }

    public static Logger getLogger(Class clazz) {
        return LOGGER_FACTORY.getLogger(clazz);
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract void debug(String var1);

    public abstract void debug(String var1, String var2);

    public abstract void info(String var1);

    public abstract void info(String var1, String var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, String var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    static {
        Configuration conf;
        LoggerFactory loggerFactory = null;
        String loggerFactoryImpl = System.getProperty(LOGGER_FACTORY_IMPLEMENTATION);
        if (loggerFactoryImpl != null) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable(loggerFactoryImpl, loggerFactoryImpl);
        }
        if ((loggerFactoryImpl = (conf = ConfigurationContext.getInstance()).getLoggerFactory()) != null) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable(loggerFactoryImpl, loggerFactoryImpl);
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("org.slf4j.impl.StaticLoggerBinder", "twitter4jads.internal.logging.SLF4JLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("org.apache.commons.logging.Log", "twitter4jads.internal.logging.CommonsLoggingLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("org.apache.log4j.Logger", "twitter4jads.internal.logging.Log4JLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("com.google.appengine.api.urlfetch.URLFetchService", "twitter4jads.internal.logging.JULLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = new StdOutLoggerFactory();
        }
        LOGGER_FACTORY = loggerFactory;
        try {
            Method method = conf.getClass().getMethod("dumpConfiguration", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)conf, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

