/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.models4j;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import twitter4jads.auth.AccessToken;
import twitter4jads.auth.Authorization;
import twitter4jads.auth.AuthorizationFactory;
import twitter4jads.auth.BasicAuthorization;
import twitter4jads.auth.NullAuthorization;
import twitter4jads.auth.OAuthAuthorization;
import twitter4jads.auth.OAuthSupport;
import twitter4jads.auth.RequestToken;
import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpClientWrapper;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.http.HttpResponseEvent;
import twitter4jads.internal.http.HttpResponseListener;
import twitter4jads.internal.http.XAuthAuthorization;
import twitter4jads.internal.json.z_T4JInternalFactory;
import twitter4jads.internal.json.z_T4JInternalJSONImplFactory;
import twitter4jads.internal.models4j.Media;
import twitter4jads.internal.models4j.MediaUpload;
import twitter4jads.internal.models4j.RateLimitStatus;
import twitter4jads.internal.models4j.RateLimitStatusEvent;
import twitter4jads.internal.models4j.RateLimitStatusListener;
import twitter4jads.internal.models4j.TonUpload;
import twitter4jads.internal.models4j.TwitterAPIMonitor;
import twitter4jads.internal.models4j.TwitterBase;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.models4j.TwitterUUIDResponse;
import twitter4jads.internal.models4j.User;
import twitter4jads.internal.models4j.VideoTweetRequest;
import twitter4jads.internal.models4j.VideoTweetResponse;
import twitter4jads.models.ads.HttpVerb;

abstract class TwitterBaseImpl
implements TwitterBase,
Serializable,
OAuthSupport,
HttpResponseListener {
    protected Configuration conf;
    protected transient String screenName = null;
    protected transient long id = 0L;
    protected transient HttpClientWrapper http;
    private List<RateLimitStatusListener> rateLimitStatusListeners = new ArrayList<RateLimitStatusListener>(0);
    protected z_T4JInternalFactory factory;
    protected Authorization auth;
    private static final long serialVersionUID = -3812176145960812140L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    TwitterBaseImpl(Configuration conf, Authorization auth) {
        this.conf = conf;
        this.auth = auth;
        this.init();
    }

    private void init() {
        if (null == this.auth) {
            String consumerKey = this.conf.getOAuthConsumerKey();
            String consumerSecret = this.conf.getOAuthConsumerSecret();
            if (consumerKey != null && consumerSecret != null) {
                OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
                String accessToken = this.conf.getOAuthAccessToken();
                String accessTokenSecret = this.conf.getOAuthAccessTokenSecret();
                if (accessToken != null && accessTokenSecret != null) {
                    oauth.setOAuthAccessToken(new AccessToken(accessToken, accessTokenSecret));
                }
                this.auth = oauth;
            } else {
                this.auth = NullAuthorization.getInstance();
            }
        }
        this.http = new HttpClientWrapper(this.conf);
        this.http.setHttpResponseListener(this);
        this.setFactory();
    }

    protected void setFactory() {
        this.factory = new z_T4JInternalJSONImplFactory(this.conf);
    }

    @Override
    public String getScreenName() throws TwitterException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
        if (null == this.screenName) {
            if (this.auth instanceof BasicAuthorization) {
                this.screenName = ((BasicAuthorization)this.auth).getUserId();
                if (-1 != this.screenName.indexOf("@")) {
                    this.screenName = null;
                }
            }
            if (null == this.screenName) {
                this.fillInIDAndScreenName();
            }
        }
        return this.screenName;
    }

    @Override
    public long getId() throws TwitterException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
        if (0L == this.id) {
            this.fillInIDAndScreenName();
        }
        return this.id;
    }

    protected User fillInIDAndScreenName() throws TwitterException {
        this.ensureAuthorizationEnabled();
        User user = this.factory.createUser(this.http.get(this.conf.getRestBaseURL() + "account/verify_credentials.json", this.auth));
        this.screenName = user.getScreenName();
        this.id = user.getId();
        return user;
    }

    @Override
    public void addRateLimitStatusListener(RateLimitStatusListener listener) {
        this.rateLimitStatusListeners.add(listener);
    }

    @Override
    public void httpResponseReceived(HttpResponseEvent event) {
        block7: {
            int statusCode;
            RateLimitStatus rateLimitStatus;
            if (this.rateLimitStatusListeners.size() == 0) break block7;
            HttpResponse res = event.getResponse();
            TwitterException te = event.getTwitterException();
            if (te != null) {
                rateLimitStatus = te.getRateLimitStatus();
                statusCode = te.getStatusCode();
            } else {
                rateLimitStatus = z_T4JInternalJSONImplFactory.createRateLimitStatusFromResponseHeader(res);
                statusCode = res.getStatusCode();
            }
            if (rateLimitStatus != null) {
                RateLimitStatusEvent statusEvent = new RateLimitStatusEvent(this, rateLimitStatus, event.isAuthenticated());
                if (statusCode == 420 || statusCode == 503) {
                    for (RateLimitStatusListener listener : this.rateLimitStatusListeners) {
                        listener.onRateLimitStatus(statusEvent);
                        listener.onRateLimitReached(statusEvent);
                    }
                } else {
                    for (RateLimitStatusListener listener : this.rateLimitStatusListeners) {
                        listener.onRateLimitStatus(statusEvent);
                    }
                }
            }
        }
    }

    @Override
    public final Authorization getAuthorization() {
        return this.auth;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void shutdown() {
        if (this.http != null) {
            this.http.shutdown();
        }
    }

    protected final void ensureAuthorizationEnabled() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Authentication credentials are missing. See http://twitter4jads.org/configuration.html for the detail.");
        }
    }

    protected final void ensureOAuthEnabled() {
        if (!(this.auth instanceof OAuthAuthorization)) {
            throw new IllegalStateException("OAuth required. Authentication credentials are missing. See http://twitter4jads.org/configuration.html for the detail.");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.putFields();
        out.writeFields();
        out.writeObject(this.conf);
        out.writeObject(this.auth);
        ArrayList<RateLimitStatusListener> serializableRateLimitStatusListeners = new ArrayList<RateLimitStatusListener>(0);
        for (RateLimitStatusListener listener : this.rateLimitStatusListeners) {
            if (!(listener instanceof Serializable)) continue;
            serializableRateLimitStatusListeners.add(listener);
        }
        out.writeObject(serializableRateLimitStatusListeners);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.readFields();
        this.conf = (Configuration)stream.readObject();
        this.auth = (Authorization)stream.readObject();
        this.rateLimitStatusListeners = (List)stream.readObject();
        this.http = new HttpClientWrapper(this.conf);
        this.http.setHttpResponseListener(this);
        this.setFactory();
    }

    @Override
    public synchronized void setOAuthConsumer(String consumerKey, String consumerSecret) {
        if (null == consumerKey) {
            throw new NullPointerException("consumer key is null");
        }
        if (null == consumerSecret) {
            throw new NullPointerException("consumer secret is null");
        }
        if (this.auth instanceof NullAuthorization) {
            OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
            oauth.setOAuthConsumer(consumerKey, consumerSecret);
            this.auth = oauth;
        } else if (this.auth instanceof BasicAuthorization) {
            XAuthAuthorization xauth = new XAuthAuthorization((BasicAuthorization)this.auth);
            xauth.setOAuthConsumer(consumerKey, consumerSecret);
            this.auth = xauth;
        } else if (this.auth instanceof OAuthAuthorization) {
            throw new IllegalStateException("consumer key/secret pair already set.");
        }
    }

    @Override
    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.getOAuthRequestToken(null);
    }

    @Override
    public RequestToken getOAuthRequestToken(String callbackUrl) throws TwitterException {
        return this.getOAuth().getOAuthRequestToken(callbackUrl);
    }

    @Override
    public RequestToken getOAuthRequestToken(String callbackUrl, String xAuthAccessType) throws TwitterException {
        return this.getOAuth().getOAuthRequestToken(callbackUrl, xAuthAccessType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized AccessToken getOAuthAccessToken() throws TwitterException {
        AccessToken oauthAccessToken;
        Authorization auth = this.getAuthorization();
        if (auth instanceof BasicAuthorization) {
            BasicAuthorization basicAuth = (BasicAuthorization)auth;
            auth = AuthorizationFactory.getInstance(this.conf);
            if (!(auth instanceof OAuthAuthorization)) throw new IllegalStateException("consumer key / secret combination not supplied.");
            this.auth = auth;
            OAuthAuthorization oauthAuth = (OAuthAuthorization)auth;
            oauthAccessToken = oauthAuth.getOAuthAccessToken(basicAuth.getUserId(), basicAuth.getPassword());
        } else if (auth instanceof XAuthAuthorization) {
            XAuthAuthorization xauth = (XAuthAuthorization)auth;
            this.auth = xauth;
            OAuthAuthorization oauthAuth = new OAuthAuthorization(this.conf);
            oauthAuth.setOAuthConsumer(xauth.getConsumerKey(), xauth.getConsumerSecret());
            oauthAccessToken = oauthAuth.getOAuthAccessToken(xauth.getUserId(), xauth.getPassword());
        } else {
            oauthAccessToken = this.getOAuth().getOAuthAccessToken();
        }
        this.screenName = oauthAccessToken.getScreenName();
        this.id = oauthAccessToken.getUserId();
        return oauthAccessToken;
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        AccessToken oauthAccessToken = this.getOAuth().getOAuthAccessToken(oauthVerifier);
        this.screenName = oauthAccessToken.getScreenName();
        return oauthAccessToken;
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        OAuthSupport oauth = this.getOAuth();
        AccessToken oauthAccessToken = oauth.getOAuthAccessToken(requestToken);
        this.screenName = oauthAccessToken.getScreenName();
        return oauthAccessToken;
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        return this.getOAuth().getOAuthAccessToken(requestToken, oauthVerifier);
    }

    @Override
    public synchronized void setOAuthAccessToken(AccessToken accessToken) {
        this.getOAuth().setOAuthAccessToken(accessToken);
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(String screenName, String password) throws TwitterException {
        return this.getOAuth().getOAuthAccessToken(screenName, password);
    }

    public Media upload(MediaUpload mediaUpload) throws TwitterException {
        return this.factory.createMediaUpload(this.post(this.conf.getMediaUploadBaseUrl() + "media/upload.json", mediaUpload.asHttpParameterArray()));
    }

    public Media mediaUploadInitOrFinalize(String url, HttpParameter[] parameters) throws TwitterException {
        return this.factory.createMediaUpload(this.post(url, parameters));
    }

    public Media checkVideoUploadStatus(String url, HttpParameter[] parameters) throws TwitterException {
        return this.factory.createMediaUpload(this.get(url, parameters));
    }

    public String createVideo(String tonVideoLocation, String title, String description) throws TwitterException {
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("location", tonVideoLocation));
        if (StringUtils.isNotBlank((CharSequence)description)) {
            params.add(new HttpParameter("description", description));
        }
        if (StringUtils.isNotBlank((CharSequence)title)) {
            params.add(new HttpParameter("title", title));
        }
        return this.constructResponse(this.post(this.conf.getVideoBaseUrl(), params.toArray(new HttpParameter[params.size()])).asString(), TwitterUUIDResponse.class).getuUID();
    }

    public String createVideoImage(String tonImageLocation, String title, String description) throws TwitterException {
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("location", tonImageLocation));
        if (StringUtils.isNotBlank((CharSequence)description)) {
            params.add(new HttpParameter("description", description));
        }
        if (StringUtils.isNotBlank((CharSequence)title)) {
            params.add(new HttpParameter("title", title));
        }
        return this.constructResponse(this.post(this.conf.getVideoImageBaseUrl(), params.toArray(new HttpParameter[params.size()])).asString(), TwitterUUIDResponse.class).getuUID();
    }

    public VideoTweetResponse createVideoTweet(VideoTweetRequest request) throws TwitterException {
        return this.constructResponse(this.post(this.conf.getVideoTweetBaseUrl(), request.asHttpParamArray()).asString(), VideoTweetResponse.class);
    }

    public String uploadToTon(TonUpload tonUpload) throws TwitterException {
        this.setContentTypeAndTotalContentLength(tonUpload);
        if (tonUpload.getTotalContentLength() < 64000000L) {
            return this.uploadSingleChunkToTon(tonUpload);
        }
        return this.uploadInChunks(tonUpload);
    }

    private String uploadSingleChunkToTon(TonUpload tonUpload) throws TwitterException {
        byte[] data = this.getAllBytesToUpload(tonUpload);
        String bucketName = this.getBucketNameForTon(tonUpload.getMediaType());
        String endpoint = this.conf.getTwitterTonBaseUrl() + bucketName;
        HashMap customHeaders = Maps.newHashMap();
        customHeaders.put("Content-Type", tonUpload.getContentType());
        customHeaders.put("Content-Length", String.valueOf(data.length));
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("file", data, true)};
        HttpResponse response = this.postWithCustomHeaders(endpoint, params, customHeaders, true);
        return response.getResponseHeader("location");
    }

    private String uploadInChunks(TonUpload tonUpload) throws TwitterException {
        HttpResponse httpResponse = this.initiateResumableUpload(tonUpload.getMediaType(), tonUpload.getTotalContentLength(), tonUpload.getContentType());
        String location = httpResponse.getResponseHeader("Location");
        Long maxChunkSize = Long.valueOf(httpResponse.getResponseHeader("X-TON-Max-Chunk-Size"));
        Long minChunkSize = Long.valueOf(httpResponse.getResponseHeader("X-TON-Min-Chunk-Size"));
        Long chunkSize = this.computeChunkSize(minChunkSize, maxChunkSize);
        chunkSize = minChunkSize;
        String filePath = this.downloadContentIntoFileReturningPath(tonUpload.getMediaUrl());
        FileInputStream inputStream = null;
        BufferedInputStream dataInputStream = null;
        HttpResponse response = null;
        try {
            int length;
            inputStream = new FileInputStream(filePath);
            dataInputStream = new BufferedInputStream(inputStream);
            byte[] chunk = new byte[chunkSize.intValue()];
            Long bytesUploaded = 0L;
            while ((length = dataInputStream.read(chunk)) != -1) {
                if (length < chunkSize.intValue()) {
                    chunk = Arrays.copyOf(chunk, length);
                }
                response = this.uploadChunk(location, tonUpload.getContentType(), chunk, bytesUploaded, tonUpload.getTotalContentLength());
                bytesUploaded = bytesUploaded + (long)length;
            }
        }
        catch (IOException e) {
            try {
                throw new TwitterException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(dataInputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                this.deleteFile(filePath);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)dataInputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        this.deleteFile(filePath);
        String responseLocation = response.getResponseHeader("Location");
        if (StringUtils.isNotBlank((CharSequence)responseLocation)) {
            return responseLocation;
        }
        return location;
    }

    private Long computeChunkSize(Long min, Long max) {
        Long chunkSize = min;
        while (chunkSize < max) {
            chunkSize = chunkSize + min;
        }
        return chunkSize;
    }

    private HttpResponse initiateResumableUpload(TonUpload.MediaType mediaType, Long totalContentLength, String contentType) throws TwitterException {
        String bucketName = this.getBucketNameForTon(mediaType);
        String endpoint = this.conf.getTwitterTonBaseUrl() + bucketName + "?resumable=true";
        HashMap customHeaders = Maps.newHashMap();
        customHeaders.put("Content-Type", contentType);
        customHeaders.put("Content-Length", "0");
        customHeaders.put("X-TON-Content-Type", contentType);
        customHeaders.put("X-TON-Content-Length", String.valueOf(totalContentLength));
        HttpResponse httpResponse = this.postWithCustomHeaders(endpoint, null, customHeaders, false);
        return httpResponse;
    }

    private HttpResponse uploadChunk(String location, String contentType, byte[] data, Long uploadedBytes, Long totalContentLength) throws TwitterException {
        String endpoint = "https://ton.twitter.com" + location;
        HashMap customHeaders = Maps.newHashMap();
        customHeaders.put("Content-Type", contentType);
        customHeaders.put("Content-Length", String.valueOf(data.length));
        customHeaders.put("Content-Range", this.createContentRange(uploadedBytes, data.length, totalContentLength));
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("file", data, true)};
        return this.putWithCustomHeaders(endpoint, params, customHeaders, true);
    }

    private String createContentRange(Long uploadedBytes, int contentLength, Long totalContentLength) {
        return "bytes " + String.valueOf(uploadedBytes) + "-" + String.valueOf(uploadedBytes + (long)contentLength - 1L) + "/" + String.valueOf(totalContentLength);
    }

    private <T> T constructResponse(String response, Class<T> clazz) throws TwitterException {
        try {
            return (T)OBJECT_MAPPER.readValue(response, clazz);
        }
        catch (IOException e) {
            throw new TwitterException("Error while parsing response", e);
        }
    }

    private String getBucketNameForTon(TonUpload.MediaType mediaType) throws TwitterException {
        switch (mediaType) {
            case IMAGE: {
                return "pro_video_api";
            }
            case VIDEO: {
                return "pro_video_api";
            }
            case AUDIENCE: {
                return "ta_partner";
            }
        }
        throw new TwitterException("Unknown Ton Media Type");
    }

    private OAuthSupport getOAuth() {
        if (!(this.auth instanceof OAuthSupport)) {
            throw new IllegalStateException("OAuth consumer key/secret combination not supplied");
        }
        return (OAuthSupport)((Object)this.auth);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TwitterBaseImpl)) {
            return false;
        }
        TwitterBaseImpl that = (TwitterBaseImpl)o;
        if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) {
            return false;
        }
        if (!this.conf.equals(that.conf)) {
            return false;
        }
        if (this.http != null ? !this.http.equals(that.http) : that.http != null) {
            return false;
        }
        return this.rateLimitStatusListeners.equals(that.rateLimitStatusListeners);
    }

    public int hashCode() {
        int result = this.conf.hashCode();
        result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
        result = 31 * result + this.rateLimitStatusListeners.hashCode();
        result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpResponse executeRequest(String url, HttpVerb httpVerb) throws TwitterException {
        this.ensureAuthorizationEnabled();
        url = url.contains("?") ? url + "&" + this.getImplicitParamsStr() : url + "?" + this.getImplicitParamsStr();
        if (!this.conf.isMBeanEnabled()) {
            switch (httpVerb) {
                case GET: {
                    return this.http.get(url, this.auth);
                }
                case POST: {
                    return this.http.post(url, this.auth);
                }
                case PUT: {
                    return this.http.put(url, this.auth);
                }
                case DELETE: {
                    return this.http.delete(url, this.auth);
                }
            }
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            switch (httpVerb) {
                case GET: {
                    HttpResponse httpResponse = this.http.get(url, this.auth);
                    return httpResponse;
                }
                case POST: {
                    HttpResponse httpResponse = this.http.post(url, this.auth);
                    return httpResponse;
                }
                case PUT: {
                    HttpResponse httpResponse = this.http.put(url, this.auth);
                    return httpResponse;
                }
                case DELETE: {
                    HttpResponse httpResponse = this.http.delete(url, this.auth);
                    return httpResponse;
                }
            }
            return response;
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpResponse executeRequest(String url, HttpParameter[] params, HttpVerb httpVerb) throws TwitterException {
        this.ensureAuthorizationEnabled();
        url = url.contains("?") ? url + "&" + this.getImplicitParamsStr() : url + "?" + this.getImplicitParamsStr();
        if (!this.conf.isMBeanEnabled()) {
            switch (httpVerb) {
                case GET: {
                    return this.http.get(url, this.mergeImplicitParams(params), this.auth);
                }
                case POST: {
                    return this.http.post(url, this.mergeImplicitParams(params), this.auth);
                }
                case PUT: {
                    return this.http.put(url, this.mergeImplicitParams(params), this.auth);
                }
                case DELETE: {
                    return this.http.delete(url, this.mergeImplicitParams(params), this.auth);
                }
            }
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            switch (httpVerb) {
                case GET: {
                    HttpResponse httpResponse = this.http.get(url, this.mergeImplicitParams(params), this.auth);
                    return httpResponse;
                }
                case POST: {
                    HttpResponse httpResponse = this.http.post(url, this.mergeImplicitParams(params), this.auth);
                    return httpResponse;
                }
                case PUT: {
                    HttpResponse httpResponse = this.http.put(url, this.mergeImplicitParams(params), this.auth);
                    return httpResponse;
                }
                case DELETE: {
                    HttpResponse httpResponse = this.http.delete(url, this.mergeImplicitParams(params), this.auth);
                    return httpResponse;
                }
            }
            return response;
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse get(String url) throws TwitterException {
        this.ensureAuthorizationEnabled();
        url = url.contains("?") ? url + "&" + this.getImplicitParamsStr() : url + "?" + this.getImplicitParamsStr();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse getWithoutMergingImplicitParams(String url, HttpParameter[] params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, params, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, params, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse get(String url, HttpParameter[] params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, this.mergeImplicitParams(params), this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, this.mergeImplicitParams(params), this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse post(String url) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, this.getImplicitParams(), this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.getImplicitParams(), this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse post(String url, HttpParameter[] params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, this.mergeImplicitParams(params), this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.mergeImplicitParams(params), this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse post(String url, String requestBody) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, requestBody, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, requestBody, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse postWithCustomHeaders(String url, HttpParameter[] params, Map<String, String> customHeaders, boolean isTonUpload) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.postWithCustomHeaders(url, params, this.auth, customHeaders, isTonUpload);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.postWithCustomHeaders(url, params, this.auth, customHeaders, isTonUpload);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse putWithCustomHeaders(String url, HttpParameter[] params, Map<String, String> customHeaders, boolean isTonUpload) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.putWithCustomHeaders(url, params, this.auth, customHeaders, isTonUpload);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.putWithCustomHeaders(url, params, this.auth, customHeaders, isTonUpload);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse put(String url) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.put(url, this.getImplicitParams(), this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.put(url, this.getImplicitParams(), this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse postBatchRequest(String url, String requestBody) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.postBatchRequest(url, this.getImplicitParams(), this.auth, requestBody);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.put(url, this.getImplicitParams(), this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse put(String url, HttpParameter[] params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.put(url, this.mergeImplicitParams(params), this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.put(url, this.mergeImplicitParams(params), this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse delete(String url) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.delete(url, this.getImplicitParams(), this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.delete(url, this.getImplicitParams(), this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse delete(String url, HttpParameter[] params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.delete(url, this.mergeImplicitParams(params), this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.delete(url, this.mergeImplicitParams(params), this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    protected HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter[] params2) {
        if (params1 != null && params2 != null) {
            HttpParameter[] params = new HttpParameter[params1.length + params2.length];
            System.arraycopy(params1, 0, params, 0, params1.length);
            System.arraycopy(params2, 0, params, params1.length, params2.length);
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (params1 != null) {
            return params1;
        }
        return params2;
    }

    protected HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter params2) {
        if (params1 != null && params2 != null) {
            HttpParameter[] params = new HttpParameter[params1.length + 1];
            System.arraycopy(params1, 0, params, 0, params1.length);
            params[params.length - 1] = params2;
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (params1 != null) {
            return params1;
        }
        return new HttpParameter[]{params2};
    }

    protected HttpParameter[] mergeImplicitParams(HttpParameter[] params) {
        return this.mergeParameters(params, this.getImplicitParams());
    }

    private boolean isOk(HttpResponse response) {
        return response != null && response.getStatusCode() < 300;
    }

    abstract String getImplicitParamsStr();

    abstract HttpParameter[] getImplicitParams();

    private byte[] getAllBytesToUpload(TonUpload tonUpload) throws TwitterException {
        try {
            return IOUtils.toByteArray((InputStream)new URL(tonUpload.getMediaUrl()).openStream());
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    private void setContentTypeAndTotalContentLength(TonUpload tonUpload) throws TwitterException {
        if (tonUpload.getTotalContentLength() != null && tonUpload.getTotalContentLength() > 0L && StringUtils.isNotBlank((CharSequence)tonUpload.getContentType())) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)tonUpload.getMediaUrl())) {
            URLConnection urlConnection = null;
            try {
                URL localURL = new URL(tonUpload.getMediaUrl());
                urlConnection = localURL.openConnection();
                String contentLength = urlConnection.getHeaderField("Content-Length");
                String contentType = urlConnection.getHeaderField("Content-Type");
                if (StringUtils.isNotBlank((CharSequence)contentLength)) {
                    tonUpload.setTotalContentLength(Long.valueOf(contentLength));
                }
                tonUpload.setContentType(contentType);
            }
            catch (IOException e) {
                throw new TwitterException("Failed to determine content type and length", e);
            }
        }
    }

    private String downloadContentIntoFileReturningPath(String url) {
        String string;
        InputStream urlInputStream = null;
        FileOutputStream temporaryFileStream = null;
        try {
            urlInputStream = new URL(url).openStream();
            File tempMedia = File.createTempFile("tw-upload-temp-" + System.currentTimeMillis(), ".tmp");
            tempMedia.deleteOnExit();
            temporaryFileStream = new FileOutputStream(tempMedia);
            IOUtils.copyLarge((InputStream)urlInputStream, (OutputStream)temporaryFileStream);
            temporaryFileStream.flush();
            string = tempMedia.getAbsolutePath();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(temporaryFileStream);
                IOUtils.closeQuietly((InputStream)urlInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)temporaryFileStream);
        IOUtils.closeQuietly((InputStream)urlInputStream);
        return string;
    }

    private void deleteFile(String filePath) {
        try {
            new File(filePath).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

