/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.models4j;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import twitter4jads.internal.http.HttpRequest;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.http.HttpResponseCode;
import twitter4jads.internal.json.z_T4JInternalJSONImplFactory;
import twitter4jads.internal.json.z_T4JInternalParseUtil;
import twitter4jads.internal.models4j.ExceptionDiagnosis;
import twitter4jads.internal.models4j.RateLimitStatus;
import twitter4jads.internal.models4j.TwitterResponse;
import twitter4jads.internal.models4j.Version;
import twitter4jads.internal.org.json.JSONException;
import twitter4jads.internal.org.json.JSONObject;

public class TwitterException
extends Exception
implements TwitterResponse,
HttpResponseCode {
    private int statusCode = -1;
    private int errorCode = -1;
    private static final long serialVersionUID = -2623309261327598087L;
    private ExceptionDiagnosis exceptionDiagnosis = null;
    private HttpResponse response;
    private String errorMessage = null;
    private HttpRequest request = null;
    private static final String[] FILTER = new String[]{"twitter4jads"};
    boolean nested = false;

    public TwitterException(String message, Throwable cause) {
        super(message, cause);
        this.decode(message);
    }

    public TwitterException(String message) {
        this(message, (Throwable)null);
    }

    public TwitterException(Exception cause) {
        this(cause.getMessage(), cause);
        if (cause instanceof TwitterException) {
            TwitterException tE = (TwitterException)cause;
            tE.setNested();
            this.request = tE.request;
            this.response = tE.response;
        }
    }

    public TwitterException(String message, HttpResponse res) {
        this(message);
        this.response = res;
        this.statusCode = res.getStatusCode();
    }

    public TwitterException(String message, HttpRequest req, HttpResponse res) {
        this(message);
        this.request = req;
        this.response = res;
        this.statusCode = res.getStatusCode();
    }

    public TwitterException(String message, Exception cause, int statusCode) {
        this(message, cause);
        this.statusCode = statusCode;
    }

    @Override
    public String getMessage() {
        StringBuilder value = new StringBuilder();
        if (this.errorMessage != null && this.errorCode != -1) {
            value.append("message - ").append(this.errorMessage).append("\n");
            value.append("code - ").append(this.errorCode).append("\n");
        } else {
            value.append(super.getMessage());
        }
        if (this.statusCode != -1) {
            return TwitterException.getCause(this.statusCode) + "\n" + value.toString();
        }
        return value.toString();
    }

    private void decode(String str) {
        if (str != null && str.startsWith("{")) {
            try {
                JSONObject json = new JSONObject(str);
                if (!json.isNull("errors")) {
                    JSONObject error = json.getJSONArray("errors").getJSONObject(0);
                    this.errorMessage = error.getString("message");
                    this.errorCode = z_T4JInternalParseUtil.getInt("code", error);
                } else if (!json.isNull("error")) {
                    this.errorMessage = json.getString("error");
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getResponseHeader(String name) {
        List<String> header;
        String value = null;
        if (this.response != null && (header = this.response.getResponseHeaderFields().get(name)).size() > 0) {
            value = header.get(0);
        }
        return value;
    }

    @Override
    public RateLimitStatus getRateLimitStatus() {
        if (null == this.response) {
            return null;
        }
        return z_T4JInternalJSONImplFactory.createRateLimitStatusFromResponseHeader(this.response);
    }

    @Override
    public int getAccessLevel() {
        return z_T4JInternalParseUtil.toAccessLevel(this.response);
    }

    public int getRetryAfter() {
        int retryAfter = -1;
        if (this.statusCode == 400 || this.statusCode == 429) {
            RateLimitStatus rateLimitStatus = this.getRateLimitStatus();
            if (rateLimitStatus != null) {
                retryAfter = rateLimitStatus.getSecondsUntilReset();
            }
        } else if (this.statusCode == 420) {
            try {
                String retryAfterStr = this.response.getResponseHeader("Retry-After");
                if (retryAfterStr != null) {
                    retryAfter = Integer.valueOf(retryAfterStr);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retryAfter;
    }

    public boolean isCausedByNetworkIssue() {
        return this.getCause() instanceof IOException;
    }

    public boolean exceededRateLimitation() {
        return this.statusCode == 400 && this.getRateLimitStatus() != null && this.getRateLimitStatus().getRemaining() < 1 || this.statusCode == 420 || this.statusCode == 429;
    }

    public boolean resourceNotFound() {
        return this.statusCode == 404;
    }

    public String getExceptionCode() {
        return this.getExceptionDiagnosis().asHexString();
    }

    private ExceptionDiagnosis getExceptionDiagnosis() {
        if (null == this.exceptionDiagnosis) {
            this.exceptionDiagnosis = new ExceptionDiagnosis(this, FILTER);
        }
        return this.exceptionDiagnosis;
    }

    void setNested() {
        this.nested = true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isErrorMessageAvailable() {
        return this.errorMessage != null;
    }

    public String getActualDetailMessage() {
        return super.getMessage();
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterException that = (TwitterException)o;
        if (this.errorCode != that.errorCode) {
            return false;
        }
        if (this.nested != that.nested) {
            return false;
        }
        if (this.statusCode != that.statusCode) {
            return false;
        }
        if (this.errorMessage != null ? !this.errorMessage.equals(that.errorMessage) : that.errorMessage != null) {
            return false;
        }
        if (this.exceptionDiagnosis != null ? !this.exceptionDiagnosis.equals(that.exceptionDiagnosis) : that.exceptionDiagnosis != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(that.response) : that.response != null);
    }

    public int hashCode() {
        int result = this.statusCode;
        result = 31 * result + this.errorCode;
        result = 31 * result + (this.exceptionDiagnosis != null ? this.exceptionDiagnosis.hashCode() : 0);
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        result = 31 * result + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        result = 31 * result + (this.nested ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.getMessage() + (this.nested ? "" : "\nRelevant discussions can be found on the Internet at:\n\thttp://www.google.co.jp/search?q=" + this.getExceptionDiagnosis().getStackLineHashAsHex() + " or\n\thttp://www.google.co.jp/search?q=" + this.getExceptionDiagnosis().getLineNumberHashAsHex()) + "\nTwitterException{" + (this.nested ? "" : "exceptionCode=[" + this.getExceptionCode() + "], ") + "statusCode=" + this.statusCode + ", message=" + this.errorMessage + ", code=" + this.errorCode + ", retryAfter=" + this.getRetryAfter() + ", rateLimitStatus=" + this.getRateLimitStatus() + ", version=" + Version.getVersion() + ", headers= " + (this.response != null ? this.response.getResponseHeaderFields() : Collections.emptyMap()) + '}';
    }

    private static String getCause(int statusCode) {
        String cause;
        switch (statusCode) {
            case 304: {
                cause = "There was no new data to return.";
                break;
            }
            case 400: {
                cause = "The request was invalid. An accompanying error message will explain why. This is the status code will be returned during version 1.0 rate limiting(https://dev.twitter.com/pages/rate-limiting). In API v1.1, a request without authentication is considered invalid and you will get this response.";
                break;
            }
            case 401: {
                cause = "Authentication credentials (https://dev.twitter.com/pages/auth) were missing or incorrect. Ensure that you have set valid consumer key/secret, access token/secret, and the system clock is in sync.";
                break;
            }
            case 403: {
                cause = "The request is understood, but it has been refused. An accompanying error message will explain why. This code is used when requests are being denied due to update limits (https://support.twitter.com/articles/15364-about-twitter-limits-update-api-dm-and-following).";
                break;
            }
            case 404: {
                cause = "The URI requested is invalid or the resource requested, such as a user, does not exists. Also returned when the requested format is not supported by the requested method.";
                break;
            }
            case 406: {
                cause = "Returned by the Search API when an invalid format is specified in the request.\nReturned by the Streaming API when one or more of the parameters are not suitable for the resource. The track parameter, for example, would throw this error if:\n The track keyword is too long or too short.\n The bounding box specified is invalid.\n No predicates defined for filtered resource, for example, neither track nor follow parameter defined.\n Follow userid cannot be read.";
                break;
            }
            case 420: {
                cause = "Returned by the Search and Trends API when you are being rate limited (https://dev.twitter.com/docs/rate-limiting).\nReturned by the Streaming API:\n Too many login attempts in a short period of time.\n Running too many copies of the same application authenticating with the same account name.";
                break;
            }
            case 422: {
                cause = "Returned when an image uploaded to POST account/update_profile_banner(https://dev.twitter.com/docs/api/1/post/account/update_profile_banner) is unable to be processed.";
                break;
            }
            case 429: {
                cause = "Returned in API v1.1 when a request cannot be served due to the application's rate limit having been exhausted for the resource. See Rate Limiting in API v1.1.(https://dev.twitter.com/docs/rate-limiting/1.1)";
                break;
            }
            case 500: {
                cause = "Something is broken. Please post to the group (https://dev.twitter.com/docs/support) so the Twitter team can investigate.";
                break;
            }
            case 502: {
                cause = "Twitter is down or being upgraded.";
                break;
            }
            case 503: {
                cause = "The Twitter servers are up, but overloaded with requests. Try again later.";
                break;
            }
            case 504: {
                cause = "The Twitter servers are up, but the request couldn't be serviced due to some failure within our stack. Try again later.";
                break;
            }
            default: {
                cause = "";
            }
        }
        return statusCode + ":" + cause;
    }
}

