/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.models4j;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import twitter4jads.auth.AccessToken;
import twitter4jads.auth.Authorization;
import twitter4jads.auth.AuthorizationFactory;
import twitter4jads.auth.OAuthAuthorization;
import twitter4jads.conf.Configuration;
import twitter4jads.conf.ConfigurationContext;
import twitter4jads.internal.models4j.Twitter;

public final class TwitterFactory
implements Serializable {
    private static final Constructor<Twitter> TWITTER_CONSTRUCTOR;
    static final Authorization DEFAULT_AUTHORIZATION;
    private static final Twitter SINGLETON;
    private static final long serialVersionUID = 5193900138477709155L;
    private final Configuration conf;

    public TwitterFactory() {
        this(ConfigurationContext.getInstance());
    }

    public TwitterFactory(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
    }

    public TwitterFactory(String configTreePath) {
        this(ConfigurationContext.getInstance(configTreePath));
    }

    public Twitter getInstance() {
        return this.getInstance(AuthorizationFactory.getInstance(this.conf));
    }

    public Twitter getInstance(AccessToken accessToken) {
        String consumerKey = this.conf.getOAuthConsumerKey();
        String consumerSecret = this.conf.getOAuthConsumerSecret();
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
        oauth.setOAuthAccessToken(accessToken);
        return this.getInstance(oauth);
    }

    public Twitter getInstance(Authorization auth) {
        try {
            return TWITTER_CONSTRUCTOR.newInstance(this.conf, auth);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Twitter getSingleton() {
        return SINGLETON;
    }

    public Configuration getConf() {
        return this.conf;
    }

    static {
        Constructor<?> constructor;
        DEFAULT_AUTHORIZATION = AuthorizationFactory.getInstance(ConfigurationContext.getInstance());
        String className = null;
        if (ConfigurationContext.getInstance().isGAE()) {
            String APP_ENGINE_TWITTER_IMPL = "twitter4jads.AppEngineTwitterImpl";
            try {
                Class.forName("twitter4jads.AppEngineTwitterImpl");
                className = "twitter4jads.AppEngineTwitterImpl";
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (className == null) {
            className = "twitter4jads.TwitterImpl";
        }
        try {
            Class<?> clazz = Class.forName(className);
            constructor = clazz.getDeclaredConstructor(Configuration.class, Authorization.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        TWITTER_CONSTRUCTOR = constructor;
        try {
            SINGLETON = TWITTER_CONSTRUCTOR.newInstance(ConfigurationContext.getInstance(), DEFAULT_AUTHORIZATION);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }
}

