/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.models4j;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import twitter4jads.auth.Authorization;
import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.json.TwitterUploadMediaResponseImpl;
import twitter4jads.internal.models4j.AccountSettings;
import twitter4jads.internal.models4j.Media;
import twitter4jads.internal.models4j.PagableResponseList;
import twitter4jads.internal.models4j.Paging;
import twitter4jads.internal.models4j.RelatedResults;
import twitter4jads.internal.models4j.ResponseList;
import twitter4jads.internal.models4j.Status;
import twitter4jads.internal.models4j.StatusUpdate;
import twitter4jads.internal.models4j.Twitter;
import twitter4jads.internal.models4j.TwitterBaseImpl;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.models4j.User;
import twitter4jads.internal.util.z_T4JInternalStringUtil;
import twitter4jads.util.TwitterAdUtil;

public class TwitterImpl
extends TwitterBaseImpl
implements Twitter {
    private static final long serialVersionUID = -1486360080128882436L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String COMMAND = "command";
    public static final String MEDIA_ID = "media_id";
    public static final String SEGMENT_INDEX = "segment_index";
    public static final String MEDIA = "media";
    public static final String MEDIA_TYPE = "media_type";
    public static final String MEDIA_CATEGORY = "media_category";
    public static final String PARAM_ADDITIONAL_OWNERS = "additional_owners";
    public static final String TOTAL_BYTES = "total_bytes";
    public static final String INIT = "INIT";
    public static final String APPEND = "APPEND";
    public static final String FINALIZE = "FINALIZE";
    public static final String STATUS = "STATUS";
    private final String IMPLICIT_PARAMS_STR;
    private final HttpParameter[] IMPLICIT_PARAMS;
    private final HttpParameter INCLUDE_MY_RETWEET;
    private final HttpParameter TWEET_MODE;
    long WAIT_INTERVAL_TRANSCODING = TimeUnit.SECONDS.toMillis(5L);
    private static final Map<Configuration, HttpParameter[]> implicitParamsMap = new ConcurrentHashMap<Configuration, HttpParameter[]>();
    private static final Map<Configuration, String> implicitParamsStrMap = new ConcurrentHashMap<Configuration, String>();

    public TwitterImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.INCLUDE_MY_RETWEET = new HttpParameter("include_my_retweet", conf.isIncludeMyRetweetEnabled());
        this.TWEET_MODE = new HttpParameter("tweet_mode", conf.getTweetMode());
        HttpParameter[] implicitParams = implicitParamsMap.get(conf);
        String implicitParamsStr = implicitParamsStrMap.get(conf);
        if (implicitParams == null) {
            String includeEntities = conf.isIncludeEntitiesEnabled() ? "1" : "0";
            String includeRTs = conf.isIncludeRTsEnabled() ? "1" : "0";
            boolean contributorsEnabled = conf.getContributingTo() != -1L;
            implicitParamsStr = "include_entities=" + includeEntities + "&include_rts=" + includeRTs + (contributorsEnabled ? "&contributingto=" + conf.getContributingTo() : "");
            implicitParamsStrMap.put(conf, implicitParamsStr);
            ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
            params.add(new HttpParameter("include_entities", includeEntities));
            params.add(new HttpParameter("include_rts", includeRTs));
            if (contributorsEnabled) {
                params.add(new HttpParameter("contributingto", conf.getContributingTo()));
            }
            implicitParams = params.toArray(new HttpParameter[params.size()]);
            implicitParamsMap.put(conf, implicitParams);
        }
        this.IMPLICIT_PARAMS = implicitParams;
        this.IMPLICIT_PARAMS_STR = implicitParamsStr;
    }

    public ResponseList<Status> getRetweetsOfMe() throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets_of_me.json", new HttpParameter[]{this.TWEET_MODE}));
    }

    public ResponseList<Status> getRetweetsOfMe(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets_of_me.json", this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{this.TWEET_MODE})));
    }

    public ResponseList<Status> getScopedTimeLine(long userId, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/scoped_timeline.json", this.mergeParameters(this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", userId)}, paging.asPostParameterArray()), new HttpParameter[]{this.TWEET_MODE})));
    }

    @Override
    public ResponseList<Status> getRetweets(long statusId) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets/" + statusId + ".json?count=100", new HttpParameter[]{this.TWEET_MODE}));
    }

    @Override
    public Status showStatus(long id) throws TwitterException {
        return this.factory.createStatus(this.get(this.conf.getRestBaseURL() + "statuses/show/" + id + ".json?include_card_uri=true", this.mergeParameters(new HttpParameter[]{this.INCLUDE_MY_RETWEET}, new HttpParameter[]{this.TWEET_MODE})));
    }

    @Override
    public Status destroyStatus(long statusId) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/destroy/" + statusId + ".json", new HttpParameter[]{this.TWEET_MODE}));
    }

    @Override
    public Status updateStatus(String status) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/update.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("status", status)}, new HttpParameter[]{this.TWEET_MODE})));
    }

    @Override
    public Status updateStatus(StatusUpdate status) throws TwitterException {
        String url = this.conf.getRestBaseURL() + (status.isWithMedia() ? "statuses/update_with_media.json" : "statuses/update.json");
        return this.factory.createStatus(this.post(url, this.mergeParameters(status.asHttpParameterArray(), new HttpParameter[]{this.TWEET_MODE})));
    }

    @Override
    public Status retweetStatus(long statusId) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/retweet/" + statusId + ".json", new HttpParameter[]{this.TWEET_MODE}));
    }

    @Override
    public ResponseList<Status> lookupStatuses(long[] statusIds) throws TwitterException {
        if (statusIds == null || statusIds.length > 100) {
            throw new TwitterException("Illegal argument: Status Ids cannot be null, and maximum upto 100 tweets per request");
        }
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/lookup.json?id=" + z_T4JInternalStringUtil.join(statusIds) + "&include_card_uri=true", new HttpParameter[]{this.TWEET_MODE}));
    }

    @Override
    public String uploadMediaInChunks(String filePath, long fileSize, String mediaType, String mediaCategory, int maxChunkSize, long maxWaitTimeTranscoding, String accountUserId) throws TwitterException {
        String mediaId = this.initializeChunkUpload(fileSize, mediaType, mediaCategory, accountUserId);
        this.uploadVideoInChunks(mediaId, filePath, fileSize, maxChunkSize);
        this.finalizeChunkUpload(mediaId);
        if (StringUtils.isNotBlank((CharSequence)mediaCategory)) {
            this.waitForVideoTranscoding(mediaId, maxWaitTimeTranscoding);
        }
        return mediaId;
    }

    @Override
    public AccountSettings getAccountSettings() throws TwitterException {
        return this.factory.createAccountSettings(this.get(this.conf.getRestBaseURL() + "account/settings.json"));
    }

    @Override
    public User verifyCredentials() throws TwitterException {
        return super.fillInIDAndScreenName();
    }

    @Override
    public AccountSettings updateAccountSettings(Integer trend_locationWoeid, Boolean sleep_timeEnabled, String start_sleepTime, String end_sleepTime, String time_zone, String lang) throws TwitterException {
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(6);
        if (trend_locationWoeid != null) {
            profile.add(new HttpParameter("trend_location_woeid", trend_locationWoeid));
        }
        if (sleep_timeEnabled != null) {
            profile.add(new HttpParameter("sleep_time_enabled", sleep_timeEnabled.toString()));
        }
        if (start_sleepTime != null) {
            profile.add(new HttpParameter("start_sleep_time", start_sleepTime));
        }
        if (end_sleepTime != null) {
            profile.add(new HttpParameter("end_sleep_time", end_sleepTime));
        }
        if (time_zone != null) {
            profile.add(new HttpParameter("time_zone", time_zone));
        }
        if (lang != null) {
            profile.add(new HttpParameter("lang", lang));
        }
        return this.factory.createAccountSettings(this.post(this.conf.getRestBaseURL() + "account/settings.json", profile.toArray(new HttpParameter[profile.size()])));
    }

    @Override
    public User updateProfile(String name, String url, String location, String description) throws TwitterException {
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(4);
        this.addParameterToList(profile, "name", name);
        this.addParameterToList(profile, "url", url);
        this.addParameterToList(profile, "location", location);
        this.addParameterToList(profile, "description", description);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile.json", profile.toArray(new HttpParameter[profile.size()])));
    }

    @Override
    public User updateProfileBackgroundImage(File image, boolean tile) throws TwitterException {
        this.checkFileValidity(image);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_background_image.json", new HttpParameter[]{new HttpParameter("image", image), new HttpParameter("tile", tile)}));
    }

    @Override
    public User updateProfileBackgroundImage(InputStream image, boolean tile) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_background_image.json", new HttpParameter[]{new HttpParameter("image", "image", image), new HttpParameter("tile", tile)}));
    }

    @Override
    public User updateProfileColors(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor) throws TwitterException {
        ArrayList<HttpParameter> colors = new ArrayList<HttpParameter>(6);
        this.addParameterToList(colors, "profile_background_color", profileBackgroundColor);
        this.addParameterToList(colors, "profile_text_color", profileTextColor);
        this.addParameterToList(colors, "profile_link_color", profileLinkColor);
        this.addParameterToList(colors, "profile_sidebar_fill_color", profileSidebarFillColor);
        this.addParameterToList(colors, "profile_sidebar_border_color", profileSidebarBorderColor);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_colors.json", colors.toArray(new HttpParameter[colors.size()])));
    }

    private void addParameterToList(List<HttpParameter> colors, String paramName, String color) {
        if (color != null) {
            colors.add(new HttpParameter(paramName, color));
        }
    }

    @Override
    public User updateProfileImage(File image) throws TwitterException {
        this.checkFileValidity(image);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_image.json", new HttpParameter[]{new HttpParameter("image", image)}));
    }

    @Override
    public User updateProfileImage(InputStream image) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_image.json", new HttpParameter[]{new HttpParameter("image", "image", image)}));
    }

    private void checkFileValidity(File image) throws TwitterException {
        if (!image.exists()) {
            throw new TwitterException(new FileNotFoundException(image + " is not found."));
        }
        if (!image.isFile()) {
            throw new TwitterException(new IOException(image + " is not a file."));
        }
    }

    @Override
    public PagableResponseList<User> getBlocksList() throws TwitterException {
        return this.getBlocksList(-1L);
    }

    @Override
    public PagableResponseList<User> getBlocksList(long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "blocks/list.json?cursor=" + cursor));
    }

    @Override
    public User createBlock(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/create.json?user_id=" + userId));
    }

    @Override
    public User createBlock(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/create.json?screen_name=" + screenName));
    }

    @Override
    public User destroyBlock(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/destroy.json?user_id=" + userId));
    }

    @Override
    public User destroyBlock(String screen_name) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/destroy.json?screen_name=" + screen_name));
    }

    @Override
    public ResponseList<User> lookupUsers(long[] ids) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/lookup.json", new HttpParameter[]{new HttpParameter("user_id", z_T4JInternalStringUtil.join(ids))}));
    }

    @Override
    public ResponseList<User> lookupUsers(String[] screenNames) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/lookup.json", new HttpParameter[]{new HttpParameter("screen_name", z_T4JInternalStringUtil.join(screenNames))}));
    }

    @Override
    public User showUser(long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "users/show.json?user_id=" + userId));
    }

    @Override
    public User showUser(String screenName) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "users/show.json?screen_name=" + screenName));
    }

    @Override
    public ResponseList<User> searchUsers(String query, int page) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/search.json", new HttpParameter[]{new HttpParameter("q", query), new HttpParameter("per_page", 20), new HttpParameter("page", page)}));
    }

    @Override
    public ResponseList<User> getContributees(long userId) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributees.json?user_id=" + userId));
    }

    @Override
    public ResponseList<User> getContributees(String screenName) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributees.json?screen_name=" + screenName));
    }

    @Override
    public ResponseList<User> getContributors(long userId) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributors.json?user_id=" + userId));
    }

    @Override
    public ResponseList<User> getContributors(String screenName) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributors.json?screen_name=" + screenName));
    }

    @Override
    public void removeProfileBanner() throws TwitterException {
        this.post(this.conf.getRestBaseURL() + "account/remove_profile_banner.json");
    }

    @Override
    public void updateProfileBanner(File image) throws TwitterException {
        this.checkFileValidity(image);
        this.post(this.conf.getRestBaseURL() + "account/update_profile_banner.json", new HttpParameter[]{new HttpParameter("banner", image)});
    }

    @Override
    public void updateProfileBanner(InputStream image) throws TwitterException {
        this.post(this.conf.getRestBaseURL() + "account/update_profile_banner.json", new HttpParameter[]{new HttpParameter("banner", "banner", image)});
    }

    @Override
    public RelatedResults getRelatedResults(long statusId) throws TwitterException {
        return this.factory.createRelatedResults(this.get("https://api.twitter.com/1/related_results/show.json?id=" + Long.toString(statusId)));
    }

    protected void waitForVideoTranscoding(String mediaId, long maxWaitTime) throws TwitterException {
        String url = this.getMediaUploadUrl();
        HttpParameter[] parameters = this.createChunkedUploadStatusParams(mediaId);
        for (long totalWaitTime = 0L; totalWaitTime < maxWaitTime; totalWaitTime += this.WAIT_INTERVAL_TRANSCODING) {
            TwitterAdUtil.reallySleep(this.WAIT_INTERVAL_TRANSCODING);
            Media media = this.checkVideoUploadStatus(url, parameters);
            if (media.isStatePending()) continue;
            if (!media.isStateSucceeded()) continue;
            return;
        }
    }

    private HttpParameter[] createChunkedUploadStatusParams(String mediaId) {
        HttpParameter[] parameters = new HttpParameter[]{new HttpParameter(COMMAND, STATUS), new HttpParameter(MEDIA_ID, mediaId)};
        return parameters;
    }

    private void uploadVideoInChunks(String mediaId, String filePath, Long fileSize, int chunkSize) throws TwitterException {
        try (FileInputStream inputStream = new FileInputStream(new File(filePath));){
            long totalBytesRead = 0L;
            int segmentIndex = 0;
            while (totalBytesRead < fileSize) {
                byte[] chunk = new byte[chunkSize = chunkSize < (int)(fileSize - totalBytesRead) ? chunkSize : (int)(fileSize - totalBytesRead)];
                int bytesRead = ((InputStream)inputStream).read(chunk);
                if (bytesRead == -1) {
                    throw new IOException("EOF reached..");
                }
                this.post(this.getMediaUploadUrl(), this.createAppendParams(mediaId, segmentIndex, chunk));
                totalBytesRead += (long)bytesRead;
                ++segmentIndex;
            }
        }
        catch (Exception e) {
            throw new TwitterException(e);
        }
    }

    private HttpParameter[] createAppendParams(String mediaId, int segmentIndex, byte[] chunk) {
        HttpParameter[] parameters = new HttpParameter[]{new HttpParameter(COMMAND, APPEND), new HttpParameter(MEDIA_ID, mediaId), new HttpParameter(SEGMENT_INDEX, segmentIndex), new HttpParameter(MEDIA, "", new ByteArrayInputStream(chunk))};
        return parameters;
    }

    private String initializeChunkUpload(long fileSizeInBytes, String mediaType, String mediaCategory, String accountUserId) throws TwitterException {
        ArrayList<HttpParameter> parameters = new ArrayList<HttpParameter>();
        parameters.add(new HttpParameter(COMMAND, INIT));
        parameters.add(new HttpParameter(MEDIA_TYPE, mediaType));
        if (StringUtils.isNotBlank((CharSequence)mediaCategory)) {
            parameters.add(new HttpParameter(MEDIA_CATEGORY, mediaCategory));
        }
        parameters.add(new HttpParameter(PARAM_ADDITIONAL_OWNERS, accountUserId));
        parameters.add(new HttpParameter(TOTAL_BYTES, fileSizeInBytes));
        HttpResponse response = this.post(this.getMediaUploadUrl(), parameters.toArray(new HttpParameter[parameters.size()]));
        return new TwitterUploadMediaResponseImpl(response, this.conf).getMediaIdString();
    }

    private void finalizeChunkUpload(String mediaId) throws TwitterException {
        ArrayList<HttpParameter> parameters = new ArrayList<HttpParameter>();
        parameters.add(new HttpParameter(COMMAND, FINALIZE));
        parameters.add(new HttpParameter(MEDIA_ID, mediaId));
        this.post(this.getMediaUploadUrl(), parameters.toArray(new HttpParameter[parameters.size()]));
    }

    private String getMediaUploadUrl() {
        return this.conf.getMediaUploadBaseUrl() + "media/upload.json";
    }

    @Override
    String getImplicitParamsStr() {
        return this.IMPLICIT_PARAMS_STR;
    }

    @Override
    HttpParameter[] getImplicitParams() {
        return this.IMPLICIT_PARAMS;
    }

    public String toString() {
        return "TwitterImpl{INCLUDE_MY_RETWEET=" + this.INCLUDE_MY_RETWEET + '}';
    }
}

