/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.json;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import twitter4jads.internal.models4j.AccountTotals;
import twitter4jads.internal.models4j.Category;
import twitter4jads.internal.models4j.DirectMessage;
import twitter4jads.internal.models4j.IDs;
import twitter4jads.internal.models4j.Location;
import twitter4jads.internal.models4j.OEmbed;
import twitter4jads.internal.models4j.Place;
import twitter4jads.internal.models4j.RateLimitStatus;
import twitter4jads.internal.models4j.RelatedResults;
import twitter4jads.internal.models4j.Relationship;
import twitter4jads.internal.models4j.SavedSearch;
import twitter4jads.internal.models4j.Status;
import twitter4jads.internal.models4j.StatusDeletionNotice;
import twitter4jads.internal.models4j.Trend;
import twitter4jads.internal.models4j.Trends;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.models4j.User;
import twitter4jads.internal.models4j.UserList;
import twitter4jads.internal.org.json.JSONArray;
import twitter4jads.internal.org.json.JSONException;
import twitter4jads.internal.org.json.JSONObject;
import twitter4jads.json.JSONObjectType;

public final class DataObjectFactory {
    private static final Constructor<Status> statusConstructor;
    private static final Constructor<User> userConstructor;
    private static final Constructor<Relationship> relationshipConstructor;
    private static final Constructor<Place> placeConstructor;
    private static final Constructor<SavedSearch> savedSearchConstructor;
    private static final Constructor<Trend> trendConstructor;
    private static final Constructor<Trends> trendsConstructor;
    private static final Constructor<IDs> IDsConstructor;
    private static final Method rateLimitStatusConstructor;
    private static final Constructor<Category> categoryConstructor;
    private static final Constructor<DirectMessage> directMessageConstructor;
    private static final Constructor<Location> locationConstructor;
    private static final Constructor<UserList> userListConstructor;
    private static final Constructor<RelatedResults> relatedResultsConstructor;
    private static final Constructor<StatusDeletionNotice> statusDeletionNoticeConstructor;
    private static final Constructor<AccountTotals> accountTotalsConstructor;
    private static final Constructor<OEmbed> oembedConstructor;
    private static final ThreadLocal<Map> rawJsonMap;

    private DataObjectFactory() {
        throw new AssertionError((Object)"not intended to be instantiated.");
    }

    public static String getRawJSON(Object obj) {
        Object json = rawJsonMap.get().get(obj);
        if (json instanceof String) {
            return (String)json;
        }
        if (json != null) {
            return json.toString();
        }
        return null;
    }

    public static Status createStatus(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createStatus(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Status createStatus(JSONObject json) throws TwitterException {
        try {
            return statusConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static User createUser(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createUser(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static User createUser(JSONObject json) throws TwitterException {
        try {
            return userConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static AccountTotals createAccountTotals(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createAccountTotals(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static AccountTotals createAccountTotals(JSONObject json) throws TwitterException {
        try {
            return accountTotalsConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static Relationship createRelationship(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createRelationship(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    private static Relationship createRelationship(JSONObject json) throws TwitterException {
        try {
            return relationshipConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static Place createPlace(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createPlace(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Place createPlace(JSONObject json) throws TwitterException {
        try {
            return placeConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static SavedSearch createSavedSearch(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createSavedSearch(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static SavedSearch createSavedSearch(JSONObject json) throws TwitterException {
        try {
            return savedSearchConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static Trend createTrend(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createTrend(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Trend createTrend(JSONObject json) throws TwitterException {
        try {
            return trendConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static Trends createTrends(String rawJSON) throws TwitterException {
        try {
            return trendsConstructor.newInstance(rawJSON);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static IDs createIDs(String rawJSON) throws TwitterException {
        try {
            return IDsConstructor.newInstance(rawJSON);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static Map<String, RateLimitStatus> createRateLimitStatus(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return (Map)rateLimitStatusConstructor.invoke(Class.forName("twitter4jads.internal.json.RateLimitStatusJSONImpl"), json);
        }
        catch (ClassNotFoundException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Category createCategory(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createCategory(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Category createCategory(JSONObject json) throws TwitterException {
        try {
            return categoryConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static DirectMessage createDirectMessage(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createDirectMessage(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static DirectMessage createDirectMessage(JSONObject json) throws TwitterException {
        try {
            return directMessageConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static Location createLocation(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createLocation(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Location createLocation(JSONObject json) throws TwitterException {
        try {
            return locationConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static UserList createUserList(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createUserList(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static UserList createUserList(JSONObject json) throws TwitterException {
        try {
            return userListConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static RelatedResults createRelatedResults(String rawJSON) throws TwitterException {
        try {
            JSONArray json = new JSONArray(rawJSON);
            return DataObjectFactory.createRelatedResults(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static RelatedResults createRelatedResults(JSONArray json) throws TwitterException {
        try {
            return relatedResultsConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static OEmbed createOEmbed(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return DataObjectFactory.createOEmbed(json);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static OEmbed createOEmbed(JSONObject json) throws TwitterException {
        try {
            return oembedConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new TwitterException(e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
    }

    public static Object createObject(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            JSONObjectType.Type jsonObjectType = JSONObjectType.determine(json);
            switch (jsonObjectType) {
                case SENDER: {
                    return DataObjectFactory.registerJSONObject(directMessageConstructor.newInstance(json.getJSONObject("direct_message")), json);
                }
                case STATUS: {
                    return DataObjectFactory.registerJSONObject(statusConstructor.newInstance(json), json);
                }
                case DIRECT_MESSAGE: {
                    return DataObjectFactory.registerJSONObject(directMessageConstructor.newInstance(json.getJSONObject("direct_message")), json);
                }
                case DELETE: {
                    return DataObjectFactory.registerJSONObject(statusDeletionNoticeConstructor.newInstance(json.getJSONObject("delete").getJSONObject("status")), json);
                }
                case LIMIT: {
                    return json;
                }
                case SCRUB_GEO: {
                    return json;
                }
            }
            return json;
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new TwitterException(e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    static void clearThreadLocalMap() {
        rawJsonMap.get().clear();
    }

    static <T> T registerJSONObject(T key, Object json) {
        rawJsonMap.get().put(key, json);
        return key;
    }

    static {
        try {
            statusConstructor = Class.forName("twitter4jads.internal.json.StatusJSONImpl").getDeclaredConstructor(JSONObject.class);
            statusConstructor.setAccessible(true);
            userConstructor = Class.forName("twitter4jads.internal.json.UserJSONImpl").getDeclaredConstructor(JSONObject.class);
            userConstructor.setAccessible(true);
            relationshipConstructor = Class.forName("twitter4jads.internal.json.RelationshipJSONImpl").getDeclaredConstructor(JSONObject.class);
            relationshipConstructor.setAccessible(true);
            placeConstructor = Class.forName("twitter4jads.internal.json.PlaceJSONImpl").getDeclaredConstructor(JSONObject.class);
            placeConstructor.setAccessible(true);
            savedSearchConstructor = Class.forName("twitter4jads.internal.json.SavedSearchJSONImpl").getDeclaredConstructor(JSONObject.class);
            savedSearchConstructor.setAccessible(true);
            trendConstructor = Class.forName("twitter4jads.internal.json.TrendJSONImpl").getDeclaredConstructor(JSONObject.class);
            trendConstructor.setAccessible(true);
            trendsConstructor = Class.forName("twitter4jads.internal.json.TrendsJSONImpl").getDeclaredConstructor(String.class);
            trendsConstructor.setAccessible(true);
            IDsConstructor = Class.forName("twitter4jads.internal.json.IDsJSONImpl").getDeclaredConstructor(String.class);
            IDsConstructor.setAccessible(true);
            rateLimitStatusConstructor = Class.forName("twitter4jads.internal.json.RateLimitStatusJSONImpl").getDeclaredMethod("createRateLimitStatuses", JSONObject.class);
            rateLimitStatusConstructor.setAccessible(true);
            categoryConstructor = Class.forName("twitter4jads.internal.json.CategoryJSONImpl").getDeclaredConstructor(JSONObject.class);
            categoryConstructor.setAccessible(true);
            directMessageConstructor = Class.forName("twitter4jads.internal.json.DirectMessageJSONImpl").getDeclaredConstructor(JSONObject.class);
            directMessageConstructor.setAccessible(true);
            locationConstructor = Class.forName("twitter4jads.internal.json.LocationJSONImpl").getDeclaredConstructor(JSONObject.class);
            locationConstructor.setAccessible(true);
            userListConstructor = Class.forName("twitter4jads.internal.json.UserListJSONImpl").getDeclaredConstructor(JSONObject.class);
            userListConstructor.setAccessible(true);
            relatedResultsConstructor = Class.forName("twitter4jads.internal.json.RelatedResultsJSONImpl").getDeclaredConstructor(JSONArray.class);
            relatedResultsConstructor.setAccessible(true);
            statusDeletionNoticeConstructor = Class.forName("twitter4jads.StatusDeletionNoticeImpl").getDeclaredConstructor(JSONObject.class);
            statusDeletionNoticeConstructor.setAccessible(true);
            accountTotalsConstructor = Class.forName("twitter4jads.internal.json.AccountTotalsJSONImpl").getDeclaredConstructor(JSONObject.class);
            accountTotalsConstructor.setAccessible(true);
            oembedConstructor = Class.forName("twitter4jads.internal.json.OEmbedJSONImpl").getDeclaredConstructor(JSONObject.class);
            oembedConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        rawJsonMap = new ThreadLocal<Map>(){

            @Override
            protected Map initialValue() {
                return new HashMap();
            }
        };
    }
}

