/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.models.ads;

import com.google.api.client.util.Sets;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TwitterAdStatisticsMetrics {
    private static final Set<String> ALL_METRICS;
    private static final Map<String, Set<String>> METRICS_BY_OBJECTIVE;

    static {
        HashSet adLevelMetrics = Sets.newHashSet();
        for (MetricClass metricClass : MetricClass.values()) {
            adLevelMetrics.addAll(Arrays.asList(metricClass.getMetrics()));
        }
        HashMap metricsByObjective = Maps.newHashMap();
        for (AdObjective adObjective : AdObjective.values()) {
            HashSet metrics = Sets.newHashSet();
            for (MetricClass metricClass : adObjective.getMetricClasses()) {
                metrics.addAll(Arrays.asList(metricClass.getMetrics()));
            }
            metricsByObjective.put(adObjective.getObjective().toLowerCase(), metrics);
        }
        ALL_METRICS = Collections.unmodifiableSet(adLevelMetrics);
        METRICS_BY_OBJECTIVE = Collections.unmodifiableMap(metricsByObjective);
    }

    static enum AdObjective {
        APP_ENGAGEMENTS("app_engagements", MetricClass.ENGAGEMENT, MetricClass.MOBILE_APP_PROMOTION, MetricClass.SPEND, MetricClass.TWITTER_AUDIENCE_PLATFORM, MetricClass.VIDEO, MetricClass.OTHER),
        APP_INSTALLS("app_installs", MetricClass.ENGAGEMENT, MetricClass.MOBILE_APP_PROMOTION, MetricClass.OTHER, MetricClass.SPEND, MetricClass.TWITTER_AUDIENCE_PLATFORM, MetricClass.VIDEO),
        BRAND_ENGAGEMENTS("brand_engagements", MetricClass.CONVERSION, MetricClass.ENGAGEMENT, MetricClass.MEDIA, MetricClass.SPEND, MetricClass.TWITTER_AUDIENCE_PLATFORM, MetricClass.VIDEO, MetricClass.OTHER),
        CUSTOM("custom", MetricClass.CONVERSION, MetricClass.ENGAGEMENT, MetricClass.MEDIA, MetricClass.MOBILE_APP_PROMOTION, MetricClass.SPEND, MetricClass.TWITTER_AUDIENCE_PLATFORM, MetricClass.VIDEO, MetricClass.OTHER),
        FOLLOWERS("followers", MetricClass.CONVERSION, MetricClass.ENGAGEMENT, MetricClass.MEDIA, MetricClass.MOBILE_APP_PROMOTION, MetricClass.SPEND, MetricClass.TWITTER_AUDIENCE_PLATFORM, MetricClass.VIDEO, MetricClass.OTHER),
        LEAD_GENERATION("lead_generation", MetricClass.CONVERSION, MetricClass.ENGAGEMENT, MetricClass.SPEND, MetricClass.TWITTER_AUDIENCE_PLATFORM, MetricClass.OTHER),
        PREROLL_VIEWS("preroll_views", MetricClass.ENGAGEMENT, MetricClass.MEDIA, MetricClass.MOBILE_APP_PROMOTION, MetricClass.SPEND, MetricClass.TWITTER_AUDIENCE_PLATFORM, MetricClass.VIDEO, MetricClass.OTHER),
        TWEET_ENGAGEMENTS("tweet_engagements", MetricClass.CONVERSION, MetricClass.ENGAGEMENT, MetricClass.MEDIA, MetricClass.SPEND, MetricClass.VIDEO, MetricClass.OTHER),
        QUALIFIED_VIEWS("qualified_views", MetricClass.ENGAGEMENT, MetricClass.MEDIA, MetricClass.SPEND, MetricClass.VIDEO, MetricClass.OTHER),
        VIDEO_VIEWS("video_views", MetricClass.ENGAGEMENT, MetricClass.SPEND, MetricClass.TWITTER_AUDIENCE_PLATFORM, MetricClass.VIDEO, MetricClass.OTHER),
        WEBSITE_CLICKS("website_clicks", MetricClass.CONVERSION, MetricClass.ENGAGEMENT, MetricClass.MEDIA, MetricClass.SPEND, MetricClass.TWITTER_AUDIENCE_PLATFORM, MetricClass.OTHER),
        WEBSITE_CONVERSIONS("website_conversions", MetricClass.CONVERSION, MetricClass.ENGAGEMENT, MetricClass.MEDIA, MetricClass.SPEND, MetricClass.TWITTER_AUDIENCE_PLATFORM, MetricClass.OTHER);

        private MetricClass[] metricClasses;
        private String objective;

        private AdObjective(String objective, MetricClass ... metricClasses) {
            this.metricClasses = metricClasses;
            this.objective = objective;
        }

        public MetricClass[] getMetricClasses() {
            return this.metricClasses;
        }

        public String getObjective() {
            return this.objective;
        }
    }

    static enum MetricClass {
        ENGAGEMENT("billed_engagements", "billed_follows", "promoted_account_follows", "promoted_tweet_profile_card_engagements", "promoted_tweet_profile_clicks", "promoted_tweet_profile_engagements", "promoted_tweet_profile_favorites", "promoted_tweet_profile_follows", "promoted_tweet_profile_replies", "promoted_tweet_profile_retweets", "promoted_tweet_profile_url_clicks", "promoted_tweet_search_card_engagements", "promoted_tweet_search_clicks", "promoted_tweet_search_engagements", "promoted_tweet_search_favorites", "promoted_tweet_search_follows", "promoted_tweet_search_replies", "promoted_tweet_search_retweets", "promoted_tweet_search_url_clicks", "promoted_tweet_timeline_card_engagements", "promoted_tweet_timeline_clicks", "promoted_tweet_timeline_engagements", "promoted_tweet_timeline_favorites", "promoted_tweet_timeline_follows", "promoted_tweet_timeline_replies", "promoted_tweet_timeline_retweets", "promoted_tweet_timeline_url_clicks", "promoted_tweet_search_qualified_impressions", "promoted_tweet_timeline_qualified_impressions"),
        CONVERSION("conversion_custom", "conversion_downloads", "conversion_order_quantity", "conversion_purchases", "conversion_sale_amount", "conversion_sign_ups", "conversion_site_visits", "conversion_app_open", "conversion_key_page_views"),
        MEDIA("promoted_tweet_profile_media_views", "promoted_tweet_search_media_views", "promoted_tweet_timeline_media_views", "promoted_tweet_tpn_media_views"),
        MOBILE_APP_PROMOTION("mobile_conversion_achievement_unlocked", "mobile_conversion_achievement_unlocked_breakdown", "mobile_conversion_add_to_cart", "mobile_conversion_add_to_cart_breakdown", "mobile_conversion_add_to_wishlist", "mobile_conversion_add_to_wishlist_breakdown", "mobile_conversion_added_payment_infos", "mobile_conversion_added_payment_infos_breakdown", "mobile_conversion_checkout_initiated", "mobile_conversion_checkout_initiated_breakdown", "mobile_conversion_content_views", "mobile_conversion_content_views_breakdown", "mobile_conversion_installs", "mobile_conversion_installs_breakdown", "mobile_conversion_invites", "mobile_conversion_invites_breakdown", "mobile_conversion_level_achieved", "mobile_conversion_level_achieved_breakdown", "mobile_conversion_logins", "mobile_conversion_logins_breakdown", "mobile_conversion_order_quantity", "mobile_conversion_purchases", "mobile_conversion_purchases_breakdown", "mobile_conversion_rated", "mobile_conversion_rated_breakdown", "mobile_conversion_re_engages", "mobile_conversion_re_engages_breakdown", "mobile_conversion_reservations", "mobile_conversion_reservations_breakdown", "mobile_conversion_sale_amount_local_micro", "mobile_conversion_searches", "mobile_conversion_searches_breakdown", "mobile_conversion_shares", "mobile_conversion_shares_breakdown", "mobile_conversion_sign_ups", "mobile_conversion_sign_ups_breakdown", "mobile_conversion_spent_credits", "mobile_conversion_spent_credits_breakdown", "mobile_conversion_tutorial_completes", "mobile_conversion_tutorial_completes_breakdown", "mobile_conversion_updates", "mobile_conversion_updates_breakdown", "promoted_tweet_app_install_attempts", "promoted_tweet_app_open_attempts", "promoted_tweet_app_install_attempts_breakdown", "promoted_tweet_app_open_attempts_breakdown"),
        SPEND("billed_charge_local_micro"),
        TWITTER_AUDIENCE_PLATFORM("promoted_tweet_tpn_card_engagements", "promoted_tweet_tpn_engagement_rate", "promoted_tweet_tpn_engagements", "promoted_tweet_tpn_clicks", "promoted_tweet_tpn_favorites", "promoted_tweet_tpn_follows", "promoted_tweet_tpn_impressions", "promoted_tweet_tpn_replies", "promoted_tweet_tpn_retweets", "promoted_tweet_tpn_url_clicks", "promoted_tweet_tpn_qualified_impressions"),
        VIDEO("promoted_video_cta_clicks", "promoted_video_replays", "promoted_video_total_views", "promoted_video_views_100", "promoted_video_views_25", "promoted_video_views_50", "promoted_video_views_75"),
        OTHER("promoted_account_follow_rate", "promoted_account_impressions", "promoted_account_profile_visits", "promoted_tweet_profile_impressions", "promoted_tweet_search_engagement_rate", "promoted_tweet_search_impressions", "promoted_tweet_timeline_engagement_rate", "promoted_tweet_timeline_impressions", "promoted_tweet_profile_qualified_impressions", "promoted_tweet_profile_engagement_rate");

        private String[] metrics;

        private MetricClass(String ... metrics) {
            this.metrics = metrics;
        }

        public String[] getMetrics() {
            return this.metrics;
        }
    }
}

