/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.models.ads;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import twitter4jads.models.MetricGroup;
import twitter4jads.models.TwitterSegmentationType;
import twitter4jads.models.ads.TwitterAdObjective;

public class TwitterEntityStatisticsMetrics {
    public static final Set<String> ALL_METRIC_GROUPS;
    public static final Map<TwitterAdObjective, Set<String>> METRIC_GROUPS_BY_OBJECTIVE;
    public static final Set<String> WEB_CONVERSION_METRIC_GROUP;
    public static final Set<MetricGroup> ORGANIC_METRIC_GROUPS;
    public static final Set<MetricGroup> ENGAGEMENT_METRIC_GROUPS;

    public static Set<String> getMetricGroups(TwitterSegmentationType twitterSegmentationType) {
        if (twitterSegmentationType != null && TwitterSegmentationType.CONVERSION_TAGS == twitterSegmentationType) {
            return WEB_CONVERSION_METRIC_GROUP;
        }
        return ALL_METRIC_GROUPS;
    }

    static {
        WEB_CONVERSION_METRIC_GROUP = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{MetricGroup.WEB_CONVERSION.name()}));
        ORGANIC_METRIC_GROUPS = Sets.newHashSet((Object[])new MetricGroup[]{MetricGroup.ENGAGEMENT, MetricGroup.VIDEO});
        ENGAGEMENT_METRIC_GROUPS = Sets.newHashSet((Object[])new MetricGroup[]{MetricGroup.ENGAGEMENT});
        HashSet metricGroups = Sets.newHashSet();
        for (MetricGroup metricGroup : MetricGroup.values()) {
            metricGroups.add(metricGroup.name());
        }
        ALL_METRIC_GROUPS = Collections.unmodifiableSet(metricGroups);
        HashMap metricsGroupsByObjective = Maps.newHashMap();
        for (TwitterAdObjective adObjective : TwitterAdObjective.values()) {
            HashSet metricGroupNames = Sets.newHashSet();
            for (MetricGroup metricGroup : adObjective.getMetricGroups()) {
                metricGroupNames.add(metricGroup.name());
            }
            metricsGroupsByObjective.put(adObjective, metricGroupNames);
        }
        METRIC_GROUPS_BY_OBJECTIVE = Collections.unmodifiableMap(metricsGroupsByObjective);
    }
}

