/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.models.ads;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum TwitterOSType {
    IOS,
    ANDROID;

    private static final Map<String, TwitterOSType> NAME_TO_OS_TYPE;

    public static TwitterOSType getFromName(String name) {
        return NAME_TO_OS_TYPE.get(name);
    }

    static {
        HashMap nameToOs = Maps.newHashMap();
        for (TwitterOSType twitterOSType : TwitterOSType.values()) {
            nameToOs.put(twitterOSType.name(), twitterOSType);
        }
        NAME_TO_OS_TYPE = Collections.unmodifiableMap(nameToOs);
    }
}

