/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.util;

import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.RateLimitStatusImpl;

public class TwitterAdHttpUtils {
    public static RateLimitStatusImpl createFromResponseHeader(HttpResponse res) {
        String reset;
        String remaining;
        int remainingHits = 10;
        int limit = 10;
        int resetTimeInSeconds = 0;
        String strLimit = res.getResponseHeader("X-Rate-Limit-Limit");
        if (strLimit != null) {
            limit = Integer.parseInt(strLimit);
        }
        if ((remaining = res.getResponseHeader("X-Rate-Limit-Remaining")) != null) {
            remainingHits = Integer.parseInt(remaining);
        }
        if ((reset = res.getResponseHeader("X-Rate-Limit-Reset")) != null) {
            long longReset = Long.parseLong(reset);
            resetTimeInSeconds = (int)longReset;
        }
        return new RateLimitStatusImpl(remainingHits, limit, resetTimeInSeconds);
    }

    public static RateLimitStatusImpl createFromResponseHeaderForCostBasedRateLimit(HttpResponse res) {
        String reset;
        String remaining;
        int remainingHits = 10;
        int limit = 10;
        int resetTimeInSeconds = 0;
        String strLimit = res.getResponseHeader("X-Cost-Rate-Limit-Limit");
        if (strLimit != null) {
            limit = Integer.parseInt(strLimit);
        }
        if ((remaining = res.getResponseHeader("X-Cost-Rate-Limit-Remaining")) != null) {
            remainingHits = Integer.parseInt(remaining);
        }
        if ((reset = res.getResponseHeader("X-Cost-Rate-Limit-Reset")) != null) {
            long longReset = Long.parseLong(reset);
            resetTimeInSeconds = (int)longReset;
        }
        String costValueStr = res.getResponseHeader("X-Request-Cost");
        int costValue = 0;
        if (costValueStr != null) {
            costValue = Integer.parseInt(costValueStr);
        }
        return new RateLimitStatusImpl(remainingHits, limit, resetTimeInSeconds, costValue);
    }
}

