/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MustacheLocalizationMessageInterceptor
extends HandlerInterceptorAdapter
implements MessageSourceAware {
    public static final String DEFAULT_MODEL_KEY = "i18n";
    private static final Pattern KEY_PATTERN = Pattern.compile("(.*?)[\\s\\[]");
    private static final Pattern ARGS_PATTERN = Pattern.compile("\\[(.*?)\\]");
    private String messageKey = "i18n";
    private MessageSource messageSource;
    private LocaleResolver localeResolver;

    protected final void localize(HttpServletRequest request, String frag, Writer out) throws IOException {
        Locale locale = this.localeResolver.resolveLocale(request);
        String key = this.extractKey(frag);
        List<String> args = this.extractParameters(frag);
        String text = this.messageSource.getMessage(key, args.toArray(), locale);
        out.write(text);
    }

    protected abstract Object createHelper(HttpServletRequest var1);

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView != null) {
            modelAndView.addObject(this.messageKey, this.createHelper(request));
        }
        super.postHandle(request, response, handler, modelAndView);
    }

    private String extractKey(String key) {
        Matcher matcher = KEY_PATTERN.matcher(key);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return key;
    }

    private List<String> extractParameters(String key) {
        Matcher matcher = ARGS_PATTERN.matcher(key);
        ArrayList<String> args = new ArrayList<String>();
        while (matcher.find()) {
            args.add(matcher.group(1));
        }
        return args;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }
}

