/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.mustache.java;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheException;
import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.view.mustache.MustacheTemplate;
import org.springframework.web.servlet.view.mustache.MustacheTemplateException;
import org.springframework.web.servlet.view.mustache.MustacheTemplateFactory;
import org.springframework.web.servlet.view.mustache.java.MustacheJTemplate;

public class MustacheJTemplateFactory
extends DefaultMustacheFactory
implements ResourceLoaderAware,
MustacheTemplateFactory {
    private ResourceLoader resourceLoader;
    private String prefix = "";
    private String encoding = (String)Objects.firstNonNull((Object)System.getProperty("mustache.template.encoding"), (Object)"UTF-8");

    public void setSuffix(String suffix) {
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public MustacheTemplate getTemplate(String templateURL) throws MustacheTemplateException {
        return new MustacheJTemplate(this.compile(templateURL));
    }

    public Reader getReader(String resourceName) {
        Resource resource = this.resourceLoader.getResource(resourceName = this.getFullyQualifiedResourceName(resourceName));
        if (resource.exists()) {
            try {
                return new InputStreamReader(resource.getInputStream(), this.encoding);
            }
            catch (IOException e) {
                throw new MustacheException("Failed to load template: " + resourceName, (Throwable)e);
            }
        }
        throw new MustacheException("No template exists named: " + resourceName);
    }

    private String getFullyQualifiedResourceName(String resourceName) {
        if (resourceName.startsWith(this.prefix)) {
            return resourceName;
        }
        return this.prefix + resourceName;
    }
}

