/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.mustache.jmustache;

import com.samskivert.mustache.Mustache;
import java.io.Reader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.view.mustache.MustacheTemplate;
import org.springframework.web.servlet.view.mustache.MustacheTemplateException;
import org.springframework.web.servlet.view.mustache.MustacheTemplateFactory;
import org.springframework.web.servlet.view.mustache.jmustache.JMustacheTemplate;
import org.springframework.web.servlet.view.mustache.jmustache.JMustacheTemplateLoader;

public class JMustacheTemplateFactory
implements MustacheTemplateFactory,
InitializingBean {
    private JMustacheTemplateLoader templateLoader;
    private Mustache.Compiler compiler = null;
    private boolean standardsMode = false;
    private boolean escapeHTML = true;
    private String prefix = "";
    private String suffix = "";

    public MustacheTemplate getTemplate(String templateURL) throws MustacheTemplateException {
        try {
            Reader templateReader = this.templateLoader.getTemplate(templateURL);
            return new JMustacheTemplate(this.compiler.compile(templateReader));
        }
        catch (Exception e) {
            throw new MustacheTemplateException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.templateLoader.setPrefix(this.prefix);
        this.templateLoader.setSuffix(this.suffix);
        if (this.compiler == null) {
            this.compiler = Mustache.compiler().escapeHTML(this.escapeHTML).standardsMode(this.standardsMode).withLoader((Mustache.TemplateLoader)this.templateLoader);
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Required
    public void setTemplateLoader(JMustacheTemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public void setStandardsMode(boolean standardsMode) {
        this.standardsMode = standardsMode;
    }

    public void setEscapeHTML(boolean escapeHTML) {
        this.escapeHTML = escapeHTML;
    }

    public void setCompiler(Mustache.Compiler compiler) {
        this.compiler = compiler;
    }
}

