/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.mustache.jmustache;

import com.samskivert.mustache.Mustache;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class JMustacheTemplateLoader
implements Mustache.TemplateLoader,
ResourceLoaderAware {
    private ResourceLoader resourceLoader;
    private String prefix = "";
    private String suffix = "";

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Reader getTemplate(String filename) throws Exception {
        Resource resource;
        if (!filename.startsWith(this.prefix)) {
            filename = this.prefix + filename;
        }
        if (!filename.endsWith(this.suffix)) {
            filename = filename + this.suffix;
        }
        if ((resource = this.resourceLoader.getResource(filename)).exists()) {
            return new InputStreamReader(resource.getInputStream(), Charset.defaultCharset());
        }
        throw new FileNotFoundException(filename);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

