/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.slf4j.helpers.MessageFormatter;

public class XLog {
    public static final String MESSAGE_PARAMETER_SEPARATOR = ": ";
    public static final String PARAMETERS_SEPARATOR = ", ";
    public static final String ENTRY_KEY_VALUE_SEPARATOR = "=";
    @NonNull
    private String message;
    private List<Object> binds = new ArrayList<Object>();
    private List<Parameter> parameters = new ArrayList<Parameter>();

    public static XLog of(String message) {
        return new XLog(message);
    }

    public static XLog of(@NonNull StringBuilder message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        return new XLog(message.toString());
    }

    public String bind(Object ... binds) {
        if (binds == null) {
            throw new NullPointerException("binds");
        }
        return this.bindAnd(binds).toString();
    }

    public XLog bindAnd(Object ... binds) {
        if (binds == null) {
            throw new NullPointerException("binds");
        }
        this.binds.addAll(Arrays.asList(binds));
        return this;
    }

    public String value(Object ... values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return this.valueAnd(values).toString();
    }

    public XLog valueAnd(Object ... values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        for (Object value : values) {
            this.parameters.add(new ValueParameter(value));
        }
        return this;
    }

    public String entry(String key, Object value) {
        return this.entryAnd(key, value).toString();
    }

    public XLog entryAnd(String key, Object value) {
        this.parameters.add(new EntryParameter(key, value));
        return this;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.binds.isEmpty()) {
            buffer.append(MessageFormatter.arrayFormat((String)this.message, (Object[])this.binds.toArray()).getMessage());
        } else {
            buffer.append(this.message);
        }
        if (!this.parameters.isEmpty()) {
            buffer.append(MESSAGE_PARAMETER_SEPARATOR);
            for (Parameter parameter : this.parameters) {
                buffer.append(parameter.toString());
                buffer.append(PARAMETERS_SEPARATOR);
            }
            buffer.setLength(buffer.length() - PARAMETERS_SEPARATOR.length());
        }
        return buffer.toString();
    }

    @ConstructorProperties(value={"message"})
    protected XLog(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XLog)) {
            return false;
        }
        XLog other = (XLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.message;
        String other$message = other.message;
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<Object> this$binds = this.binds;
        List<Object> other$binds = other.binds;
        if (this$binds == null ? other$binds != null : !((Object)this$binds).equals(other$binds)) {
            return false;
        }
        List<Parameter> this$parameters = this.parameters;
        List<Parameter> other$parameters = other.parameters;
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.message;
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<Object> $binds = this.binds;
        result = result * 59 + ($binds == null ? 43 : ((Object)$binds).hashCode());
        List<Parameter> $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    protected static class EntryParameter
    implements Parameter {
        private String key;
        private Object value;

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.key);
            buffer.append(XLog.ENTRY_KEY_VALUE_SEPARATOR);
            buffer.append(String.valueOf(this.value));
            return buffer.toString();
        }

        @ConstructorProperties(value={"key", "value"})
        public EntryParameter(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    protected static class ValueParameter
    implements Parameter {
        private Object value;

        public String toString() {
            return String.valueOf(this.value);
        }

        @ConstructorProperties(value={"value"})
        public ValueParameter(Object value) {
            this.value = value;
        }
    }

    protected static interface Parameter {
    }
}

