/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationResolver;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.PlaceholderReplacer;

public class XFlyway
extends Flyway {
    private PlaceholderReplacer placeholderReplacer;

    protected <T> T execute(Flyway.Command<T> command) {
        return (T)super.execute(new XCommand<T>(command, this.placeholderReplacer));
    }

    public PlaceholderReplacer getPlaceholderReplacer() {
        return this.placeholderReplacer;
    }

    public void setPlaceholderReplacer(PlaceholderReplacer placeholderReplacer) {
        this.placeholderReplacer = placeholderReplacer;
    }

    protected static class XCommand<T>
    implements Flyway.Command<T> {
        @NonNull
        private final Flyway.Command<T> delegate;
        private final PlaceholderReplacer placeholderReplacer;

        public T execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, List<FlywayCallback> effectiveCallbacks) {
            if (this.placeholderReplacer != null) {
                this.replacePlaceholderReplacer(migrationResolver, this.placeholderReplacer);
            }
            return (T)this.delegate.execute(migrationResolver, schemaHistory, database, schemas, effectiveCallbacks);
        }

        protected void replacePlaceholderReplacer(MigrationResolver migrationResolver, PlaceholderReplacer placeholderReplacer) {
            if (migrationResolver instanceof CompositeMigrationResolver) {
                try {
                    Field field = CompositeMigrationResolver.class.getDeclaredField("migrationResolvers");
                    field.setAccessible(true);
                    Collection childResolvers = (Collection)field.get(migrationResolver);
                    for (MigrationResolver childResolver : childResolvers) {
                        this.replacePlaceholderReplacer(childResolver, placeholderReplacer);
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Failed to get 'MigrationResolver'", e);
                }
            }
            if (migrationResolver instanceof SqlMigrationResolver) {
                try {
                    Field field = SqlMigrationResolver.class.getDeclaredField("placeholderReplacer");
                    field.setAccessible(true);
                    field.set(migrationResolver, placeholderReplacer);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Failed to set 'PlaceholderReplacer'", e);
                }
            }
        }

        @ConstructorProperties(value={"delegate", "placeholderReplacer"})
        public XCommand(@NonNull Flyway.Command<T> delegate, PlaceholderReplacer placeholderReplacer) {
            if (delegate == null) {
                throw new NullPointerException("delegate");
            }
            this.delegate = delegate;
            this.placeholderReplacer = placeholderReplacer;
        }
    }
}

