/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.beans.ConstructorProperties;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.util.XSqlReplacer;

public class XMysqlToH2SqlReplacer
extends XSqlReplacer {
    protected static final String GROUP_1 = "$1";
    protected static final String LF = "\n";
    protected static final String INDEX = "INDEX";

    @Override
    public String replace(String sql) {
        XInternalReplacer replacer = new XInternalReplacer(sql);
        replacer.remove("(?m)^SET(?:\\s+)(?:.*?)@(?:.*?)$");
        replacer.remove("(?m)^LOCK(?:\\s+)TABLES(?:\\s+)(?:.*?)$");
        replacer.remove("(?m)^UNLOCK(?:\\s+)TABLES(?:.*?)$");
        replacer.replace("UNIQUE(?:\\s*)/\\*(?:\\s*)CONSTRAINT(?:\\s*)\\*/(?:\\s*)(INDEX|KEY)", INDEX);
        replacer.replace("DROP(?:\\s*)/\\*(?:\\s*)UNIQUE(?:\\s*)\\*/(?:\\s*)(INDEX|KEY)", "DROP CONSTRAINT");
        replacer.replace("FULLTEXT(?:\\s+)(?:INDEX|KEY)", INDEX);
        replacer.replace("FULLTEXT", INDEX);
        replacer.remove("WITH(?:\\s+)PARSER(?:\\s+)(?:[^;]+)");
        replacer.replace("(\\s+)TEXT([\\s,]+)", "$1VARCHAR(2147483647)$2");
        replacer.replace("((?:\\s*)CHANGE(?:\\s+)COLUMN(?:\\s+)(?:.*?))(?:\\s+)AFTER(?:\\s+)(?:[^;]+)", GROUP_1);
        replacer.replace("((?:\\s*)MODIFY(?:\\s+)COLUMN(?:\\s+)(?:.*?))(?:\\s+)AFTER(?:\\s+)(?:[^;]+)", GROUP_1);
        replacer.remove("(?:\\s*)CHARACTER(?:\\s+)SET(?:\\s+)'(?:.*?)'(?:\\s+)COLLATE(?:\\s+)'(?:.*?)'");
        replacer.remove("(?:\\s*)CHARACTER(?:\\s+)SET(?:\\s+)'(?:.*?)'");
        replacer.remove("(?:\\s*)COMMENT(?:\\s*)=(?:\\s*)(?:[^;]+)");
        replacer.replace("`", "\"");
        replacer.remove("(?m)^--(?:.*?)$");
        replacer.replace("\r\n", LF);
        replacer.replace("\r", LF);
        replacer.replace("\n\n\n+", "\n\n");
        replacer.replace("^\n+", LF);
        replacer.replace("\n+$", LF);
        return replacer.toString();
    }

    protected static class XInternalReplacer {
        private String sql;

        public XInternalReplacer remove(String pattern) {
            return this.replace(pattern, "");
        }

        public XInternalReplacer replace(String pattern, String replacement) {
            this.sql = Pattern.compile(pattern, 2).matcher(this.sql).replaceAll(replacement);
            return this;
        }

        public String toString() {
            return this.sql;
        }

        @ConstructorProperties(value={"sql"})
        public XInternalReplacer(String sql) {
            this.sql = sql;
        }
    }
}

