/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.util.List;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.XFlyway;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.flyway.XFlywayProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.XDataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.XHibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConditionalOnProperty(prefix="spring.flyway", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={XFlywayProperties.class})
@AutoConfigureBefore(value={FlywayAutoConfiguration.class})
@AutoConfigureAfter(value={XDataSourceAutoConfiguration.class, XHibernateJpaAutoConfiguration.class})
public class XFlywayAutoConfiguration
extends FlywayAutoConfiguration {
    @Bean
    @Primary
    public XFlywayProperties flywayProperties() {
        return new XFlywayProperties();
    }

    @Configuration
    @ConditionalOnMissingBean(value={Flyway.class})
    @EnableConfigurationProperties(value={FlywayProperties.class})
    public static class XFlywayConfiguration
    extends FlywayAutoConfiguration.FlywayConfiguration {
        public XFlywayConfiguration(XFlywayProperties properties, DataSourceProperties dataSourceProperties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayMigrationStrategy> migrationStrategy, ObjectProvider<List<FlywayCallback>> flywayCallbacks) {
            super((FlywayProperties)properties, dataSourceProperties, resourceLoader, dataSource, flywayDataSource, migrationStrategy, flywayCallbacks);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.flyway")
        public Flyway flyway() {
            Flyway config = super.flyway();
            XFlyway flyway = new XFlyway();
            flyway.setDataSource(config.getDataSource());
            flyway.setCallbacks(config.getCallbacks());
            flyway.setLocations(config.getLocations());
            return flyway;
        }
    }
}

