/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.h2;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import lombok.NonNull;
import org.h2.tools.Server;
import org.springframework.boot.autoconfigure.AbstractDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.h2.XH2ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactoryBean;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Server.class})
@ConditionalOnProperty(prefix="spring.h2.server", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={XH2ServerProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class XH2ServerAutoConfiguration {
    @NonNull
    private XH2ServerProperties properties;

    @Bean(initMethod="start", destroyMethod="stop")
    public Server h2Server() throws IllegalStateException {
        try {
            return Server.createTcpServer((String[])this.buildArguments().toArray(new String[0]));
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to build server", e);
        }
    }

    protected List<String> buildArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-tcp");
        args.add("-tcpPort");
        args.add(String.valueOf(this.determinePort()));
        args.add("-baseDir");
        args.add(this.determineBaseDir());
        if (this.properties.isAllowOthers()) {
            args.add("-tcpAllowOthers");
        }
        if (this.properties.isDaemon()) {
            args.add("-tcpDaemon");
        }
        return args;
    }

    protected int determinePort() throws IllegalStateException {
        int port = this.properties.getPort();
        if (port != 0) {
            return port;
        }
        return SocketUtils.findAvailableTcpPort();
    }

    protected String determineBaseDir() throws IllegalStateException {
        String baseDir = this.properties.getBaseDir();
        if (StringUtils.hasText((String)baseDir)) {
            return baseDir;
        }
        try {
            return Files.createTempDirectory("H2-", new FileAttribute[0]).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to determine base directory", e);
        }
    }

    @ConstructorProperties(value={"properties"})
    public XH2ServerAutoConfiguration(@NonNull XH2ServerProperties properties) {
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        this.properties = properties;
    }

    @Configuration
    @ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseFactoryBean.class})
    public static class DataSourceDependsOnBeanFactoryPostProcessor
    extends AbstractDependsOnBeanFactoryPostProcessor {
        public DataSourceDependsOnBeanFactoryPostProcessor() {
            super(DataSource.class, EmbeddedDatabaseFactoryBean.class, new String[]{"h2Server"});
        }
    }
}

