/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.boot.autoconfigure.jdbc.XDataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.datasource")
public class XMultipleDataSourceProperties
extends XDataSourceProperties {
    public static final String SINGLE_NAME_PLACEHOLDER = "{name}";
    private Map<String, XDataSourceProperties> multiple = new HashMap<String, XDataSourceProperties>();

    public XDataSourceProperties getSingleDataSourceProperties(String name) {
        XDataSourceProperties properties = this.multiple.getOrDefault(name, new XDataSourceProperties());
        String pattern = Pattern.quote(SINGLE_NAME_PLACEHOLDER);
        if (StringUtils.hasText((String)properties.getName())) {
            properties.setName(properties.getName().replaceAll(pattern, name));
        }
        if (StringUtils.hasText((String)properties.getUrl())) {
            properties.setUrl(properties.getUrl().replaceAll(pattern, name));
        }
        Map<String, Map<String, Object>> parent = properties.getParameter();
        for (String parentKey : parent.keySet()) {
            Map<String, Object> child = parent.get(parentKey);
            for (String childKey : child.keySet()) {
                Object value = child.get(childKey);
                if (!(value instanceof String)) continue;
                child.put(childKey, ((String)value).replaceAll(pattern, name));
            }
        }
        return properties;
    }

    public Map<String, XDataSourceProperties> getMultiple() {
        return this.multiple;
    }

    public void setMultiple(Map<String, XDataSourceProperties> multiple) {
        this.multiple = multiple;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XMultipleDataSourceProperties)) {
            return false;
        }
        XMultipleDataSourceProperties other = (XMultipleDataSourceProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, XDataSourceProperties> this$multiple = this.getMultiple();
        Map<String, XDataSourceProperties> other$multiple = other.getMultiple();
        return !(this$multiple == null ? other$multiple != null : !((Object)this$multiple).equals(other$multiple));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof XMultipleDataSourceProperties;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Map<String, XDataSourceProperties> $multiple = this.getMultiple();
        result = result * 59 + ($multiple == null ? 43 : ((Object)$multiple).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "XMultipleDataSourceProperties(super=" + super.toString() + ", multiple=" + this.getMultiple() + ")";
    }
}

