/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import lombok.NonNull;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.autoconfigure.orm.jpa.XHibernateJpaConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.XJpaProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.jdbc.SchemaManagementProvider;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.transaction.jta.JtaTransactionManager;

public class XHibernateJpaConfigurationBuilder {
    @NonNull
    private final BeanFactory beanFactory;
    @NonNull
    private final ObjectProvider<JtaTransactionManager> jtaTransactionManager;
    @NonNull
    private final ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers;
    @NonNull
    private final ObjectProvider<Collection<DataSourcePoolMetadataProvider>> metadataProviders;
    @NonNull
    private final ObjectProvider<List<SchemaManagementProvider>> schemaManagementProviders;
    @NonNull
    private final ObjectProvider<PhysicalNamingStrategy> physicalNamingStrategy;
    @NonNull
    private final ObjectProvider<ImplicitNamingStrategy> implicitNamingStrategy;
    @NonNull
    private final ObjectProvider<IntegratorProvider> integratorProvider;
    @NonNull
    private final ObjectProvider<List<HibernatePropertiesCustomizer>> hibernatePropertiesCustomizers;

    public XHibernateJpaConfiguration build(DataSource dataSource, XJpaProperties jpaProperties) {
        XHibernateJpaConfiguration config = new XHibernateJpaConfiguration(dataSource, jpaProperties, this.jtaTransactionManager, this.transactionManagerCustomizers, this.metadataProviders, this.schemaManagementProviders, this.physicalNamingStrategy, this.implicitNamingStrategy, this.integratorProvider, this.hibernatePropertiesCustomizers);
        config.setBeanFactory(this.beanFactory);
        return config;
    }

    @ConstructorProperties(value={"beanFactory", "jtaTransactionManager", "transactionManagerCustomizers", "metadataProviders", "schemaManagementProviders", "physicalNamingStrategy", "implicitNamingStrategy", "integratorProvider", "hibernatePropertiesCustomizers"})
    public XHibernateJpaConfigurationBuilder(@NonNull BeanFactory beanFactory, @NonNull ObjectProvider<JtaTransactionManager> jtaTransactionManager, @NonNull ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers, @NonNull ObjectProvider<Collection<DataSourcePoolMetadataProvider>> metadataProviders, @NonNull ObjectProvider<List<SchemaManagementProvider>> schemaManagementProviders, @NonNull ObjectProvider<PhysicalNamingStrategy> physicalNamingStrategy, @NonNull ObjectProvider<ImplicitNamingStrategy> implicitNamingStrategy, @NonNull ObjectProvider<IntegratorProvider> integratorProvider, @NonNull ObjectProvider<List<HibernatePropertiesCustomizer>> hibernatePropertiesCustomizers) {
        if (beanFactory == null) {
            throw new NullPointerException("beanFactory");
        }
        if (jtaTransactionManager == null) {
            throw new NullPointerException("jtaTransactionManager");
        }
        if (transactionManagerCustomizers == null) {
            throw new NullPointerException("transactionManagerCustomizers");
        }
        if (metadataProviders == null) {
            throw new NullPointerException("metadataProviders");
        }
        if (schemaManagementProviders == null) {
            throw new NullPointerException("schemaManagementProviders");
        }
        if (physicalNamingStrategy == null) {
            throw new NullPointerException("physicalNamingStrategy");
        }
        if (implicitNamingStrategy == null) {
            throw new NullPointerException("implicitNamingStrategy");
        }
        if (integratorProvider == null) {
            throw new NullPointerException("integratorProvider");
        }
        if (hibernatePropertiesCustomizers == null) {
            throw new NullPointerException("hibernatePropertiesCustomizers");
        }
        this.beanFactory = beanFactory;
        this.jtaTransactionManager = jtaTransactionManager;
        this.transactionManagerCustomizers = transactionManagerCustomizers;
        this.metadataProviders = metadataProviders;
        this.schemaManagementProviders = schemaManagementProviders;
        this.physicalNamingStrategy = physicalNamingStrategy;
        this.implicitNamingStrategy = implicitNamingStrategy;
        this.integratorProvider = integratorProvider;
        this.hibernatePropertiesCustomizers = hibernatePropertiesCustomizers;
    }
}

