/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.sql.DataSource;
import lombok.NonNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.jdbc.XMultipleDataSourceConfigurerAdapter;
import org.springframework.boot.autoconfigure.orm.jpa.XHibernateJpaConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.XHibernateJpaConfigurationBuilder;
import org.springframework.boot.autoconfigure.orm.jpa.XHibernateJpaConfigurationBuilderConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.XJpaProperties;
import org.springframework.boot.autoconfigure.orm.jpa.XMultipleJpaConfigurer;
import org.springframework.boot.autoconfigure.orm.jpa.XMultipleJpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableConfigurationProperties(value={XMultipleJpaProperties.class})
@Import(value={XHibernateJpaConfigurationBuilderConfiguration.class})
public abstract class XMultipleJpaConfigurerAdapter
extends XMultipleDataSourceConfigurerAdapter
implements XMultipleJpaConfigurer {
    public static final String TRANSACTION_MANAGER_BEAN_SUFFIX = "TransactionManager";
    public static final String ENTITY_MANAGER_FACTORY_BEAN_SUFFIX = "EntityManagerFactory";
    private XHibernateJpaConfigurationBuilder configBuilder;
    private XMultipleJpaProperties jpaProperties;

    protected XHibernateJpaConfigurationBuilder getConfigBuilder() {
        Assert.notNull((Object)this.configBuilder, (String)"Field 'configBuilder' must be set");
        return this.configBuilder;
    }

    protected XMultipleJpaProperties getMultipleJpaProperties() {
        Assert.notNull((Object)((Object)this.jpaProperties), (String)"Field 'jpaProperties' must be set");
        return this.jpaProperties;
    }

    protected XJpaProperties getSingleJpaProperties(String name) {
        return this.getMultipleJpaProperties().getSingleJpaProperties(name);
    }

    @Override
    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        if (beanFactory == null) {
            throw new NullPointerException("beanFactory");
        }
        super.setBeanFactory(beanFactory);
        this.configBuilder = (XHibernateJpaConfigurationBuilder)beanFactory.getBean(XHibernateJpaConfigurationBuilder.class);
        this.jpaProperties = (XMultipleJpaProperties)((Object)beanFactory.getBean(XMultipleJpaProperties.class));
    }

    @Override
    public DataSource dataSource() {
        return super.dataSource();
    }

    @Override
    public PlatformTransactionManager transactionManager() {
        return this.createTransactionManager(this.determineSingleName(TRANSACTION_MANAGER_BEAN_SUFFIX));
    }

    @Override
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        return this.createEntityManagerFactory(this.determineSingleName(TRANSACTION_MANAGER_BEAN_SUFFIX));
    }

    protected PlatformTransactionManager createTransactionManager(String name) {
        return this.createConfig(name).transactionManager();
    }

    protected LocalContainerEntityManagerFactoryBean createEntityManagerFactory(String name) {
        XHibernateJpaConfiguration config = this.createConfig(name);
        EntityManagerFactoryBuilder factoryBuilder = config.entityManagerFactoryBuilder(config.jpaVendorAdapter(), new XSimpleObjectProvider<PersistenceUnitManager>(this.persistenceUnitManager()));
        LocalContainerEntityManagerFactoryBean factory = config.entityManagerFactory(factoryBuilder);
        LinkedHashSet<String> packagesToScan = new LinkedHashSet<String>();
        packagesToScan.addAll(this.basePackages());
        if (this.basePackageClass() != null) {
            packagesToScan.add(ClassUtils.getPackageName(this.basePackageClass()));
        }
        for (Class<?> basePackageClass : this.basePackageClasses()) {
            packagesToScan.add(ClassUtils.getPackageName(basePackageClass));
        }
        if (!CollectionUtils.isEmpty(packagesToScan)) {
            factory.setPackagesToScan(packagesToScan.toArray(new String[0]));
        }
        return factory;
    }

    protected XHibernateJpaConfiguration createConfig(String name) {
        return this.configBuilder.build(this.dataSource(), this.getSingleJpaProperties(name));
    }

    protected PersistenceUnitManager persistenceUnitManager() {
        return null;
    }

    protected Collection<String> basePackages() {
        return Collections.emptyList();
    }

    protected Class<?> basePackageClass() {
        return null;
    }

    protected Collection<Class<?>> basePackageClasses() {
        return Collections.emptyList();
    }

    protected static class XSimpleObjectProvider<T>
    implements ObjectProvider<T> {
        private final T bean;

        public T getObject() {
            throw new UnsupportedOperationException();
        }

        public T getObject(Object ... args) {
            throw new UnsupportedOperationException();
        }

        public T getIfAvailable() {
            return this.bean;
        }

        public T getIfUnique() {
            throw new UnsupportedOperationException();
        }

        @ConstructorProperties(value={"bean"})
        public XSimpleObjectProvider(T bean) {
            this.bean = bean;
        }
    }
}

