/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.boot.autoconfigure.orm.jpa.XJpaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.jpa")
public class XMultipleJpaProperties
extends XJpaProperties {
    private Map<String, XJpaProperties> multiple = new HashMap<String, XJpaProperties>();

    public XJpaProperties getSingleJpaProperties(String name) {
        XJpaProperties.XHibernate hibernate;
        XJpaProperties properties = this.multiple.getOrDefault(name, new XJpaProperties());
        String pattern = Pattern.quote("{name}");
        if (StringUtils.hasText((String)properties.getPersistenceUnitName())) {
            properties.setPersistenceUnitName(properties.getPersistenceUnitName().replaceAll(pattern, name));
        }
        if (StringUtils.hasText((String)(hibernate = properties.getHibernate()).getDefaultSchema())) {
            hibernate.setDefaultSchema(hibernate.getDefaultSchema().replaceAll(pattern, name));
        }
        return properties;
    }

    public Map<String, XJpaProperties> getMultiple() {
        return this.multiple;
    }

    public void setMultiple(Map<String, XJpaProperties> multiple) {
        this.multiple = multiple;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XMultipleJpaProperties)) {
            return false;
        }
        XMultipleJpaProperties other = (XMultipleJpaProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, XJpaProperties> this$multiple = this.getMultiple();
        Map<String, XJpaProperties> other$multiple = other.getMultiple();
        return !(this$multiple == null ? other$multiple != null : !((Object)this$multiple).equals(other$multiple));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof XMultipleJpaProperties;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Map<String, XJpaProperties> $multiple = this.getMultiple();
        result = result * 59 + ($multiple == null ? 43 : ((Object)$multiple).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "XMultipleJpaProperties(super=" + super.toString() + ", multiple=" + this.getMultiple() + ")";
    }
}

