/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc;

import java.beans.ConstructorProperties;
import org.springframework.util.StringUtils;

public enum XDatabaseDriver {
    UNKNOWN(null, null),
    MYSQL_REPLICATION("jdbc:mysql:replication", "com.mysql.jdbc.ReplicationDriver");

    private String jdbcUrlPrefix;
    private String driverClassName;

    public static XDatabaseDriver fromJdbcUrl(String url) {
        if (StringUtils.hasText((String)url)) {
            for (XDatabaseDriver driver : XDatabaseDriver.values()) {
                if (!url.startsWith(driver.jdbcUrlPrefix + ":")) continue;
                return driver;
            }
        }
        return UNKNOWN;
    }

    @ConstructorProperties(value={"jdbcUrlPrefix", "driverClassName"})
    private XDatabaseDriver(String jdbcUrlPrefix, String driverClassName) {
        this.jdbcUrlPrefix = jdbcUrlPrefix;
        this.driverClassName = driverClassName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }
}

