/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.springframework.util.CollectionUtils;

public enum XDatabaseUrl {
    H2(";", ";"){

        @Override
        protected String convertParamKey(String key) {
            String converted = super.convertParamKey(key);
            converted = converted.replaceAll("([a-z])([A-Z]+)", "$1_$2");
            return converted.toUpperCase();
        }

        @Override
        protected String convertParamValue(Object value) {
            String converted = String.valueOf(value);
            if (value instanceof Boolean) {
                converted = converted.toUpperCase();
            }
            return converted;
        }
    }
    ,
    MYSQL("?", "&"){

        @Override
        protected String convertParamKey(String key) {
            String converted = super.convertParamKey(key);
            converted = converted.replaceAll("^useSsl$", "useSSL");
            return converted;
        }
    };

    private String paramStarter;
    private String paramEntryJoiner;

    public static String build(@NonNull String url, Map<String, Object> params) throws IllegalStateException {
        if (url == null) {
            throw new NullPointerException("url");
        }
        for (XDatabaseUrl value : XDatabaseUrl.values()) {
            if (!url.startsWith("jdbc:" + value.name().toLowerCase() + ":")) continue;
            return value.buildInternal(url, params);
        }
        throw new IllegalStateException("Faile to build URL: " + url);
    }

    protected String buildInternal(@NonNull String url, Map<String, Object> params) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        if (CollectionUtils.isEmpty(params)) {
            return url;
        }
        ArrayList<String> entries = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            StringBuilder query = new StringBuilder();
            query.append(this.convertParamKey(entry.getKey()));
            query.append("=");
            query.append(this.convertParamValue(entry.getValue()));
            entries.add(query.toString());
        }
        StringBuilder builder = new StringBuilder();
        builder.append(url);
        if (!entries.isEmpty()) {
            if (!url.contains(this.paramStarter)) {
                builder.append(this.paramStarter);
            } else {
                builder.append(this.paramEntryJoiner);
            }
            builder.append(String.join((CharSequence)this.paramEntryJoiner, entries));
        }
        return builder.toString();
    }

    protected String convertParamKey(String key) {
        Matcher matcher = Pattern.compile("-[a-z]").matcher(key);
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (matcher.find()) {
            builder.append(key.substring(index, matcher.start()));
            builder.append(matcher.group(0).replaceAll("-", "").toUpperCase());
            index = matcher.end();
        }
        builder.append(key.substring(index));
        return builder.toString();
    }

    protected String convertParamValue(Object value) {
        return String.valueOf(value);
    }

    @ConstructorProperties(value={"paramStarter", "paramEntryJoiner"})
    private XDatabaseUrl(String paramStarter, String paramEntryJoiner) {
        this.paramStarter = paramStarter;
        this.paramEntryJoiner = paramEntryJoiner;
    }
}

