/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.orm.jpa.hibernate;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.UserType;

public class XUserTypeIntegrator
implements Integrator {
    private List<UserType> userTypes;

    public XUserTypeIntegrator(UserType ... userTypes) {
        this(Arrays.asList(userTypes));
    }

    public XUserTypeIntegrator(@NonNull List<UserType> userTypes) {
        if (userTypes == null) {
            throw new NullPointerException("userTypes");
        }
        this.userTypes = userTypes;
    }

    public void integrate(@NonNull Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (metadata == null) {
            throw new NullPointerException("metadata");
        }
        TypeResolver resolver = ((MetadataImplementor)metadata).getTypeResolver();
        for (UserType userType : this.userTypes) {
            resolver.registerTypeOverride(userType, new String[]{userType.returnedClass().getName()});
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

