/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import lombok.NonNull;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.repository.Repository;
import org.springframework.util.Assert;

public abstract class XRepositoryAware<R extends Repository<?, ?>>
implements BeanFactoryAware {
    private R repository;

    protected R repository() {
        Assert.notNull(this.repository, (String)String.format("Repository not found: %s", this.getClass()));
        return this.repository;
    }

    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        if (beanFactory == null) {
            throw new NullPointerException("beanFactory");
        }
        this.repository = (Repository)beanFactory.getBean(XRepositoryAware.getTypeParameterClass(this, XRepositoryAware.class, 0));
    }

    protected static <T> Class<T> getTypeParameterClass(Object object, Class<?> genericClass, int index) throws IllegalStateException {
        Class targetClass = AopUtils.getTargetClass((Object)object);
        HashSet<Type> genericTypes = new HashSet<Type>();
        genericTypes.add(targetClass.getGenericSuperclass());
        genericTypes.addAll(Arrays.asList(targetClass.getGenericInterfaces()));
        ParameterizedType paramedType = null;
        for (Type genericType : genericTypes) {
            ParameterizedType castType;
            if (!ParameterizedType.class.isInstance(genericType) || !(castType = (ParameterizedType)genericType).getRawType().equals(genericClass)) continue;
            paramedType = castType;
            break;
        }
        if (paramedType == null) {
            throw new IllegalStateException(String.format("Parameter type is not set: %s", genericClass));
        }
        Type[] paramTypes = paramedType.getActualTypeArguments();
        if (paramTypes.length <= index) {
            throw new IllegalStateException(String.format("Invalid parameter index: %s, %d", genericClass, index));
        }
        Type paramType = paramTypes[index];
        if (!Class.class.isInstance(paramType)) {
            throw new IllegalStateException(String.format("Parameter type is not actual: %s", genericClass));
        }
        Class paramClass = (Class)paramType;
        return paramClass;
    }
}

