/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.CustomDatabaseDriver;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.DatabaseUrl;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.datasource")
public class CustomDataSourceProperties
extends DataSourceProperties {
    public static final String PREFIX = "spring.datasource";
    private Map<String, Map<String, Object>> parameter = new LinkedHashMap<String, Map<String, Object>>();

    public String determineDriverClassName() {
        String className;
        if (StringUtils.hasText((String)this.getUrl()) && StringUtils.hasText((String)(className = CustomDatabaseDriver.fromJdbcUrl(this.getUrl()).getDriverClassName()))) {
            return className;
        }
        return super.determineDriverClassName();
    }

    public String determineUrl() {
        String url = super.determineUrl();
        return DatabaseUrl.build(url, this.parameter.get(DatabaseDriver.fromJdbcUrl((String)url).getId()));
    }

    public Map<String, Map<String, Object>> getParameter() {
        return this.parameter;
    }

    public void setParameter(Map<String, Map<String, Object>> parameter) {
        this.parameter = parameter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomDataSourceProperties)) {
            return false;
        }
        CustomDataSourceProperties other = (CustomDataSourceProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Map<String, Object>> this$parameter = this.getParameter();
        Map<String, Map<String, Object>> other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !((Object)this$parameter).equals(other$parameter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomDataSourceProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Map<String, Object>> $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : ((Object)$parameter).hashCode());
        return result;
    }

    public String toString() {
        return "CustomDataSourceProperties(super=" + super.toString() + ", parameter=" + this.getParameter() + ")";
    }
}

