/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.lang.reflect.Method;
import javax.sql.DataSource;
import lombok.NonNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.CustomDataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.MultipleDataSourceConfigurer;
import org.springframework.boot.autoconfigure.jdbc.MultipleDataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

@Configuration
@EnableConfigurationProperties(value={MultipleDataSourceProperties.class})
public abstract class MultipleDataSourceConfigurerAdapter
implements MultipleDataSourceConfigurer,
BeanFactoryAware {
    public static final String DATASOURCE_BEAN_SUFFIX = "DataSource";
    public static final String DATASOURCE_PROPERTIES_PREFIX = "spring.datasource.hikari.multiple.";
    private MultipleDataSourceProperties properties;

    protected MultipleDataSourceProperties getProperties() {
        Assert.notNull((Object)((Object)this.properties), (String)"'MultipleDataSourceProperties' not set");
        return this.properties;
    }

    protected CustomDataSourceProperties getSingleProperties(String name) {
        return this.getProperties().getSingleProperties(name);
    }

    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        if (beanFactory == null) {
            throw new NullPointerException("beanFactory is marked @NonNull but is null");
        }
        this.properties = (MultipleDataSourceProperties)((Object)beanFactory.getBean(MultipleDataSourceProperties.class));
    }

    @Override
    public DataSource dataSource() {
        return this.createDataSource(this.determineSingleName(DATASOURCE_BEAN_SUFFIX));
    }

    protected DataSource createDataSource(String name) {
        return new DataSourceConfiguration.Hikari().dataSource((DataSourceProperties)this.getSingleProperties(name));
    }

    protected String determineSingleName(@NonNull String beanSuffix) {
        if (beanSuffix == null) {
            throw new NullPointerException("beanSuffix is marked @NonNull but is null");
        }
        Assert.hasLength((String)beanSuffix, (String)"Invalid '@Bean' suffix");
        String methodName = beanSuffix.substring(0, 1).toLowerCase() + beanSuffix.substring(1);
        Method method = ReflectionUtils.findMethod(this.getClass(), (String)methodName);
        Assert.notNull((Object)method, (String)("Method '" + methodName + "' is not found"));
        Qualifier qualifier = (Qualifier)AnnotationUtils.findAnnotation((Method)method, Qualifier.class);
        if (qualifier != null) {
            String value = qualifier.value();
            Assert.isTrue((value.length() > 0 ? 1 : 0) != 0, (String)"'@Qualifier#value' must be set");
            return value;
        }
        Bean bean = (Bean)AnnotationUtils.findAnnotation((Method)method, Bean.class);
        Assert.notNull((Object)bean, (String)"'@Bean' must be set");
        Assert.isTrue((bean.name().length > 0 ? 1 : 0) != 0, (String)"'@Bean#name' must be set");
        String singleName = bean.name()[0].replaceAll(beanSuffix + "$", "");
        Assert.isTrue((!singleName.isEmpty() ? 1 : 0) != 0, (String)("'@Bean#name' must be 'xxx" + beanSuffix + "'"));
        return singleName;
    }
}

