/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import lombok.NonNull;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.orm.jpa.CustomHibernateJpaConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.CustomJpaProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.jdbc.SchemaManagementProvider;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.transaction.jta.JtaTransactionManager;

public class CustomHibernateJpaConfigurationBuilder {
    @NonNull
    private final BeanFactory beanFactory;
    @NonNull
    private final ObjectProvider<JtaTransactionManager> jtaTransactionManager;
    @NonNull
    private final ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers;
    @NonNull
    private final ObjectProvider<Collection<DataSourcePoolMetadataProvider>> metadataProviders;
    @NonNull
    private final ObjectProvider<List<SchemaManagementProvider>> schemaManagementProviders;
    @NonNull
    private final ObjectProvider<PhysicalNamingStrategy> physicalNamingStrategy;
    @NonNull
    private final ObjectProvider<ImplicitNamingStrategy> implicitNamingStrategy;
    @NonNull
    private final ObjectProvider<IntegratorProvider> integratorProvider;
    @NonNull
    private final ObjectProvider<List<HibernatePropertiesCustomizer>> hibernatePropertiesCustomizers;

    public CustomHibernateJpaConfiguration build(DataSource dataSource, CustomJpaProperties jpaProperties) {
        CustomHibernateJpaConfiguration config = new CustomHibernateJpaConfiguration(dataSource, jpaProperties, this.jtaTransactionManager, this.transactionManagerCustomizers, this.metadataProviders, this.schemaManagementProviders, this.physicalNamingStrategy, this.implicitNamingStrategy, this.integratorProvider, this.hibernatePropertiesCustomizers);
        config.setBeanFactory(this.beanFactory);
        return config;
    }

    public CustomHibernateJpaConfigurationBuilder(@NonNull BeanFactory beanFactory, @NonNull ObjectProvider<JtaTransactionManager> jtaTransactionManager, @NonNull ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers, @NonNull ObjectProvider<Collection<DataSourcePoolMetadataProvider>> metadataProviders, @NonNull ObjectProvider<List<SchemaManagementProvider>> schemaManagementProviders, @NonNull ObjectProvider<PhysicalNamingStrategy> physicalNamingStrategy, @NonNull ObjectProvider<ImplicitNamingStrategy> implicitNamingStrategy, @NonNull ObjectProvider<IntegratorProvider> integratorProvider, @NonNull ObjectProvider<List<HibernatePropertiesCustomizer>> hibernatePropertiesCustomizers) {
        if (beanFactory == null) {
            throw new NullPointerException("beanFactory is marked @NonNull but is null");
        }
        if (jtaTransactionManager == null) {
            throw new NullPointerException("jtaTransactionManager is marked @NonNull but is null");
        }
        if (transactionManagerCustomizers == null) {
            throw new NullPointerException("transactionManagerCustomizers is marked @NonNull but is null");
        }
        if (metadataProviders == null) {
            throw new NullPointerException("metadataProviders is marked @NonNull but is null");
        }
        if (schemaManagementProviders == null) {
            throw new NullPointerException("schemaManagementProviders is marked @NonNull but is null");
        }
        if (physicalNamingStrategy == null) {
            throw new NullPointerException("physicalNamingStrategy is marked @NonNull but is null");
        }
        if (implicitNamingStrategy == null) {
            throw new NullPointerException("implicitNamingStrategy is marked @NonNull but is null");
        }
        if (integratorProvider == null) {
            throw new NullPointerException("integratorProvider is marked @NonNull but is null");
        }
        if (hibernatePropertiesCustomizers == null) {
            throw new NullPointerException("hibernatePropertiesCustomizers is marked @NonNull but is null");
        }
        this.beanFactory = beanFactory;
        this.jtaTransactionManager = jtaTransactionManager;
        this.transactionManagerCustomizers = transactionManagerCustomizers;
        this.metadataProviders = metadataProviders;
        this.schemaManagementProviders = schemaManagementProviders;
        this.physicalNamingStrategy = physicalNamingStrategy;
        this.implicitNamingStrategy = implicitNamingStrategy;
        this.integratorProvider = integratorProvider;
        this.hibernatePropertiesCustomizers = hibernatePropertiesCustomizers;
    }
}

