/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.lang.reflect.Method;
import java.util.Map;
import lombok.NonNull;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.jpa")
public class CustomJpaProperties
extends JpaProperties {
    public static final String PREFIX = "spring.jpa";
    private String persistenceUnitName;
    private CustomHibernate hibernate = new CustomHibernate();

    public Map<String, Object> getHibernateProperties(HibernateSettings settings) {
        return this.hibernate.getAdditionalProperties(this.getProperties(), settings);
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public CustomHibernate getHibernate() {
        return this.hibernate;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public void setHibernate(CustomHibernate hibernate) {
        this.hibernate = hibernate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomJpaProperties)) {
            return false;
        }
        CustomJpaProperties other = (CustomJpaProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$persistenceUnitName = this.getPersistenceUnitName();
        String other$persistenceUnitName = other.getPersistenceUnitName();
        if (this$persistenceUnitName == null ? other$persistenceUnitName != null : !this$persistenceUnitName.equals(other$persistenceUnitName)) {
            return false;
        }
        CustomHibernate this$hibernate = this.getHibernate();
        CustomHibernate other$hibernate = other.getHibernate();
        return !(this$hibernate == null ? other$hibernate != null : !((Object)((Object)this$hibernate)).equals((Object)other$hibernate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomJpaProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $persistenceUnitName = this.getPersistenceUnitName();
        result = result * 59 + ($persistenceUnitName == null ? 43 : $persistenceUnitName.hashCode());
        CustomHibernate $hibernate = this.getHibernate();
        result = result * 59 + ($hibernate == null ? 43 : ((Object)((Object)$hibernate)).hashCode());
        return result;
    }

    public String toString() {
        return "CustomJpaProperties(super=" + super.toString() + ", persistenceUnitName=" + this.getPersistenceUnitName() + ", hibernate=" + (Object)((Object)this.getHibernate()) + ")";
    }

    public static class CustomHibernate
    extends JpaProperties.Hibernate {
        protected static final String DEFAULT_SCHEMA = "hibernate.default_schema";
        private String defaultSchema;

        protected Map<String, Object> getAdditionalProperties(Map<String, String> existing, HibernateSettings settings) {
            Method method = ReflectionUtils.findMethod(JpaProperties.Hibernate.class, (String)"getAdditionalProperties", (Class[])new Class[]{Map.class, HibernateSettings.class});
            Assert.notNull((Object)method, (String)"Method 'getAdditionalProperties' not found");
            ReflectionUtils.makeAccessible((Method)method);
            Map result = (Map)ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])new Object[]{existing, settings});
            this.applyDefaultSchema(result);
            return result;
        }

        protected void applyDefaultSchema(@NonNull Map<String, Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked @NonNull but is null");
            }
            if (StringUtils.hasText((String)this.defaultSchema)) {
                properties.put(DEFAULT_SCHEMA, this.defaultSchema);
            }
        }

        public String getDefaultSchema() {
            return this.defaultSchema;
        }

        public void setDefaultSchema(String defaultSchema) {
            this.defaultSchema = defaultSchema;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomHibernate)) {
                return false;
            }
            CustomHibernate other = (CustomHibernate)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$defaultSchema = this.getDefaultSchema();
            String other$defaultSchema = other.getDefaultSchema();
            return !(this$defaultSchema == null ? other$defaultSchema != null : !this$defaultSchema.equals(other$defaultSchema));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomHibernate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $defaultSchema = this.getDefaultSchema();
            result = result * 59 + ($defaultSchema == null ? 43 : $defaultSchema.hashCode());
            return result;
        }

        public String toString() {
            return "CustomJpaProperties.CustomHibernate(super=" + super.toString() + ", defaultSchema=" + this.getDefaultSchema() + ")";
        }
    }
}

