/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.boot.autoconfigure.orm.jpa.CustomJpaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.jpa")
public class MultipleJpaProperties
extends CustomJpaProperties {
    private Map<String, CustomJpaProperties> multiple = new HashMap<String, CustomJpaProperties>();

    public CustomJpaProperties getSingleJpaProperties(String name) {
        CustomJpaProperties.CustomHibernate hibernate;
        CustomJpaProperties properties = this.multiple.getOrDefault(name, new CustomJpaProperties());
        String pattern = Pattern.quote("{name}");
        if (StringUtils.hasText((String)properties.getPersistenceUnitName())) {
            properties.setPersistenceUnitName(properties.getPersistenceUnitName().replaceAll(pattern, name));
        }
        if (StringUtils.hasText((String)(hibernate = properties.getHibernate()).getDefaultSchema())) {
            hibernate.setDefaultSchema(hibernate.getDefaultSchema().replaceAll(pattern, name));
        }
        return properties;
    }

    public Map<String, CustomJpaProperties> getMultiple() {
        return this.multiple;
    }

    public void setMultiple(Map<String, CustomJpaProperties> multiple) {
        this.multiple = multiple;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleJpaProperties)) {
            return false;
        }
        MultipleJpaProperties other = (MultipleJpaProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, CustomJpaProperties> this$multiple = this.getMultiple();
        Map<String, CustomJpaProperties> other$multiple = other.getMultiple();
        return !(this$multiple == null ? other$multiple != null : !((Object)this$multiple).equals(other$multiple));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultipleJpaProperties;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, CustomJpaProperties> $multiple = this.getMultiple();
        result = result * 59 + ($multiple == null ? 43 : ((Object)$multiple).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MultipleJpaProperties(super=" + super.toString() + ", multiple=" + this.getMultiple() + ")";
    }
}

