/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc;

import org.springframework.util.StringUtils;

public enum CustomDatabaseDriver {
    UNKNOWN(null, null),
    MYSQL_REPLICATION("jdbc:mysql:replication", "com.mysql.jdbc.ReplicationDriver");

    private String jdbcUrlPrefix;
    private String driverClassName;

    public static CustomDatabaseDriver fromJdbcUrl(String url) {
        if (StringUtils.hasText((String)url)) {
            for (CustomDatabaseDriver driver : CustomDatabaseDriver.values()) {
                if (!url.startsWith(driver.jdbcUrlPrefix + ":")) continue;
                return driver;
            }
        }
        return UNKNOWN;
    }

    private CustomDatabaseDriver(String jdbcUrlPrefix, String driverClassName) {
        this.jdbcUrlPrefix = jdbcUrlPrefix;
        this.driverClassName = driverClassName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }
}

