/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.orm.jpa.hibernate;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy;

public class CustomSpringPhysicalNamingStrategy
extends SpringPhysicalNamingStrategy {
    public Identifier toPhysicalCatalogName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return super.toPhysicalCatalogName(this.applyAdditionally(name), jdbcEnvironment);
    }

    public Identifier toPhysicalSchemaName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return super.toPhysicalSchemaName(this.applyAdditionally(name), jdbcEnvironment);
    }

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return super.toPhysicalTableName(this.applyAdditionally(name), jdbcEnvironment);
    }

    public Identifier toPhysicalSequenceName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return super.toPhysicalSequenceName(this.applyAdditionally(name), jdbcEnvironment);
    }

    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return super.toPhysicalColumnName(this.applyAdditionally(name), jdbcEnvironment);
    }

    protected Identifier applyAdditionally(Identifier name) {
        if (name == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(name.getText());
        for (int i = 1; i < buffer.length() - 1; ++i) {
            if (Character.isUpperCase(buffer.charAt(i - 1)) && Character.isUpperCase(buffer.charAt(i)) && Character.isLowerCase(buffer.charAt(i + 1))) {
                buffer.insert(i++, '_');
                continue;
            }
            if (!Character.isLowerCase(buffer.charAt(i - 1)) || !Character.isUpperCase(buffer.charAt(i)) || !Character.isUpperCase(buffer.charAt(i + 1))) continue;
            buffer.insert(i++, '_');
        }
        return new Identifier(buffer.toString(), name.isQuoted());
    }
}

