/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.XLoggingInterceptor;
import org.springframework.web.client.RestTemplate;

public class XLoggingInterceptorCustomizer
implements RestTemplateCustomizer {
    public void customize(RestTemplate restTemplate) {
        new RestTemplateBuilder(new RestTemplateCustomizer[0]).additionalInterceptors(new ClientHttpRequestInterceptor[]{new XLoggingInterceptor().showBody(this.isShowBody())}).configure(restTemplate);
    }

    protected boolean isShowBody() {
        Logger logger = LoggerFactory.getLogger((String)(RestTemplate.class.getName() + ".showBody"));
        return logger.isTraceEnabled() || logger.isDebugEnabled() || logger.isInfoEnabled() || logger.isWarnEnabled() || logger.isErrorEnabled();
    }
}

