/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import lombok.NonNull;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.XRestTemplate;

public class XObjectMapperCustomizer
implements RestTemplateCustomizer {
    public void customize(RestTemplate restTemplate) {
        ObjectMapper objectMapper = XRestTemplate.getObjectMapper(restTemplate);
        this.customize(objectMapper);
        XRestTemplate.setObjectMapper(restTemplate, objectMapper);
    }

    protected void customize(@NonNull ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper");
        }
        objectMapper.registerModules(new Module[]{new JavaTimeModule(), new Jdk8Module()}).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

