/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.http.HttpResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StreamUtils;

public class XClientHttpResponse
implements ClientHttpResponse {
    @NonNull
    private ClientHttpResponse delegate;

    public String getStatusLine() throws IOException {
        if (this.delegate instanceof SimpleClientHttpResponse) {
            Field field = ReflectionUtils.findField(SimpleClientHttpResponse.class, (String)"connection");
            Assert.notNull((Object)field, (String)"Field 'connection' not found");
            ReflectionUtils.makeAccessible((Field)field);
            return ((HttpURLConnection)ReflectionUtils.getField((Field)field, (Object)this.delegate)).getHeaderField(0);
        }
        if (this.delegate instanceof HttpComponentsClientHttpResponse) {
            Field field = ReflectionUtils.findField(HttpComponentsClientHttpResponse.class, (String)"httpResponse");
            Assert.notNull((Object)field, (String)"Field 'httpResponse' not found");
            ReflectionUtils.makeAccessible((Field)field);
            return ((HttpResponse)ReflectionUtils.getField((Field)field, (Object)this.delegate)).getStatusLine().toString();
        }
        throw new IOException("Unsupported client: " + this.delegate.getClass());
    }

    public String getHttpVersion() throws IOException {
        String statusLine = this.getStatusLine();
        Matcher matcher = Pattern.compile("(HTTP/[0-9.]+)").matcher(statusLine);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IOException("HTTP version not found: " + statusLine);
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.delegate.getStatusCode();
    }

    public int getRawStatusCode() throws IOException {
        return this.delegate.getRawStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.delegate.getStatusText();
    }

    public HttpHeaders getHeaders() {
        return this.delegate.getHeaders();
    }

    public InputStream getBody() throws IOException {
        return this.delegate.getBody();
    }

    public String getBodyAsString() throws IOException {
        return this.getBodyAsString(StandardCharsets.UTF_8);
    }

    public String getBodyAsString(Charset charset) throws IOException {
        return StreamUtils.copyToString((InputStream)this.getBody(), (Charset)charset);
    }

    public void close() {
        this.delegate.close();
    }

    @ConstructorProperties(value={"delegate"})
    public XClientHttpResponse(@NonNull ClientHttpResponse delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.delegate = delegate;
    }
}

