/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.XBodyCachingClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class XLoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final String DEFAULT_LOG_START_SEPARATOR = "-->";
    private static final String DEFAULT_LOG_END_SEPARATOR = "<--";
    private static final String LOG_LINE_JOINER = " ";
    private static final String LOG_HEADER_JOINER = ": ";
    private Logger logger;
    private boolean showBody;
    @NonNull
    private Charset defaultBodyCharset = StandardCharsets.UTF_8;
    @NonNull
    private String logStartSeparator = "-->";
    @NonNull
    private String logEndSeparator = "<--";

    public XLoggingInterceptor() {
        this(LoggerFactory.getLogger(RestTemplate.class));
    }

    public XLoggingInterceptor(@NonNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        this.logger = logger;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
        if (execution == null) {
            throw new NullPointerException("execution");
        }
        if (this.isLogEnabled()) {
            this.logRequest(request, body);
        }
        ClientHttpResponse response = execution.execute(request, body);
        if (this.isLogEnabled()) {
            if (!XBodyCachingClientHttpResponse.class.isInstance(response)) {
                response = new XBodyCachingClientHttpResponse(response);
            }
            this.logResponse((XBodyCachingClientHttpResponse)response);
        }
        return response;
    }

    protected boolean isLogEnabled() {
        return this.logger.isTraceEnabled() || this.logger.isDebugEnabled() || this.logger.isInfoEnabled() || this.logger.isWarnEnabled() || this.logger.isErrorEnabled();
    }

    protected synchronized void logRequest(@NonNull HttpRequest request, @NonNull byte[] body) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (body == null) {
            throw new NullPointerException("body");
        }
        if (StringUtils.hasText((String)this.logStartSeparator)) {
            this.logLine(this.logStartSeparator);
        }
        this.logLine(String.join((CharSequence)LOG_LINE_JOINER, request.getMethod().name(), request.getURI().toString()));
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.logLine(String.join((CharSequence)LOG_HEADER_JOINER, (CharSequence)entry.getKey(), value));
            }
        }
        if (this.showBody && body.length > 0) {
            this.logLine("");
            this.logLine(new String(body, this.defaultBodyCharset));
        }
        if (StringUtils.hasText((String)this.logEndSeparator)) {
            this.logLine(this.logEndSeparator);
        }
    }

    protected synchronized void logResponse(@NonNull XBodyCachingClientHttpResponse response) throws IOException {
        byte[] body;
        if (response == null) {
            throw new NullPointerException("response");
        }
        if (StringUtils.hasText((String)this.logStartSeparator)) {
            this.logLine(this.logStartSeparator);
        }
        this.logLine(response.getStatusLine());
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.logLine(String.join((CharSequence)LOG_HEADER_JOINER, (CharSequence)entry.getKey(), value));
            }
        }
        MediaType mediaType = response.getHeaders().getContentType();
        if (this.showBody && mediaType != null && (body = FileCopyUtils.copyToByteArray((InputStream)response.getBody())).length > 0) {
            Charset charset = mediaType.getCharset();
            if (charset == null) {
                charset = this.defaultBodyCharset;
            }
            this.logLine("");
            this.logLine(new String(body, charset));
        }
        if (StringUtils.hasText((String)this.logEndSeparator)) {
            this.logLine(this.logEndSeparator);
        }
    }

    protected void logLine(String message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(message);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info(message);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn(message);
        } else if (this.logger.isErrorEnabled()) {
            this.logger.error(message);
        }
    }

    public XLoggingInterceptor showBody(boolean showBody) {
        this.showBody = showBody;
        return this;
    }

    public XLoggingInterceptor defaultBodyCharset(@NonNull Charset defaultBodyCharset) {
        if (defaultBodyCharset == null) {
            throw new NullPointerException("defaultBodyCharset");
        }
        this.defaultBodyCharset = defaultBodyCharset;
        return this;
    }

    public XLoggingInterceptor logStartSeparator(@NonNull String logStartSeparator) {
        if (logStartSeparator == null) {
            throw new NullPointerException("logStartSeparator");
        }
        this.logStartSeparator = logStartSeparator;
        return this;
    }

    public XLoggingInterceptor logEndSeparator(@NonNull String logEndSeparator) {
        if (logEndSeparator == null) {
            throw new NullPointerException("logEndSeparator");
        }
        this.logEndSeparator = logEndSeparator;
        return this;
    }
}

