/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.NonNull;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.XRestOperations;

public class XRestTemplate
extends RestTemplate
implements XRestOperations {
    public static ObjectMapper getObjectMapper(RestTemplate restTemplate) throws IllegalStateException {
        return XRestTemplate.getMappingJackson2HttpMessageConverter(restTemplate).getObjectMapper();
    }

    public static void setObjectMapper(RestTemplate restTemplate, ObjectMapper objectMapper) throws IllegalStateException {
        XRestTemplate.getMappingJackson2HttpMessageConverter(restTemplate).setObjectMapper(objectMapper);
    }

    public static MappingJackson2HttpMessageConverter getMappingJackson2HttpMessageConverter(@NonNull RestTemplate restTemplate) throws IllegalStateException {
        if (restTemplate == null) {
            throw new NullPointerException("restTemplate");
        }
        for (HttpMessageConverter converter : restTemplate.getMessageConverters()) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            return (MappingJackson2HttpMessageConverter)converter;
        }
        throw new IllegalStateException("'MappingJackson2HttpMessageConverter' not found");
    }
}

