/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.time.Duration;
import java.util.HashMap;
import java.util.function.Supplier;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.XRestRetryTemplate;

public class XSimpleRestRetryTemplate
implements XRestRetryTemplate {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplate.class);
    private final RetryTemplate retryTemplate;
    private final SimpleRetryPolicy retryPolicy;

    public XSimpleRestRetryTemplate() {
        this(RestClientException.class);
    }

    @SafeVarargs
    public <E extends RestClientException> XSimpleRestRetryTemplate(Class<E> ... classes) {
        if (classes == null) {
            throw new NullPointerException("classes");
        }
        HashMap<Class<E>, Boolean> exceptions = new HashMap<Class<E>, Boolean>();
        for (Class<E> clazz : classes) {
            exceptions.put(clazz, true);
        }
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(1, exceptions);
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        this.retryTemplate = retryTemplate;
        this.retryPolicy = retryPolicy;
    }

    public XSimpleRestRetryTemplate setBackOffPeriod(@NonNull Duration period) {
        if (period == null) {
            throw new NullPointerException("period");
        }
        FixedBackOffPolicy policy = new FixedBackOffPolicy();
        policy.setBackOffPeriod(period.toMillis());
        this.retryTemplate.setBackOffPolicy((BackOffPolicy)policy);
        return this;
    }

    public XSimpleRestRetryTemplate setMaxAttempts(int maxAttempts) {
        this.retryPolicy.setMaxAttempts(maxAttempts);
        return this;
    }

    @Override
    public <T> T execute(@NonNull Supplier<T> supplier) throws RestClientException {
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        int maxAttempts = this.retryPolicy.getMaxAttempts();
        if (maxAttempts <= 1) {
            return supplier.get();
        }
        return (T)this.retryTemplate.execute(context -> {
            try {
                return supplier.get();
            }
            catch (RestClientException e) {
                int retryCount = context.getRetryCount() + 1;
                logger.warn("Failed in retry ({}/{}): {}", new Object[]{retryCount, maxAttempts, e.toString()});
                throw e;
            }
        });
    }
}

