/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class XSpringApplication
extends SpringApplication {
    private static final Logger logger = LoggerFactory.getLogger(SpringApplication.class);
    public static final String SHUTDOWN_URL_PROPERTY_NAME = "management.endpoint.shutdown.url";

    public XSpringApplication(Class<?> ... primarySources) {
        super((Class[])primarySources);
        this.setBannerMode(Banner.Mode.LOG);
    }

    protected Set<String> getAdditionalProfiles() {
        Field field = ReflectionUtils.findField(SpringApplication.class, (String)"additionalProfiles");
        Assert.notNull((Object)field, (String)"Field 'additionalProfiles' not found");
        ReflectionUtils.makeAccessible((Field)field);
        Set profiles = (Set)ReflectionUtils.getField((Field)field, (Object)((Object)this));
        return profiles;
    }

    public ConfigurableApplicationContext run(String ... args) throws IllegalStateException {
        String profile = new SimpleCommandLinePropertySource(args).getProperty("spring.profiles.active");
        if (!StringUtils.hasText((String)profile) && this.getAdditionalProfiles().isEmpty()) {
            throw new IllegalStateException("Active profiles not found");
        }
        return super.run(args);
    }

    public static ConfigurableApplicationContext run(Class<?> primarySource, String ... args) {
        return XSpringApplication.run(new Class[]{primarySource}, args);
    }

    public static ConfigurableApplicationContext run(Class<?>[] primarySources, String[] args) {
        return new XSpringApplication(primarySources).run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutdown(String ... args) throws IllegalStateException {
        String url = new SimpleCommandLinePropertySource(args).getProperty(SHUTDOWN_URL_PROPERTY_NAME);
        if (!StringUtils.hasText((String)url)) {
            return false;
        }
        URL request = null;
        try {
            request = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(String.format("Invalid shutdown endpoint URL: %s", url), e);
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)request.openConnection();
            connection.setRequestMethod("POST");
            int status = connection.getResponseCode();
            if (status == 200) {
                logger.debug("Active application stopped");
                boolean bl = true;
                return bl;
            }
            try {
                throw new IllegalStateException(String.format("Shutdown endpoint did not return OK: %s", status));
            }
            catch (IOException e) {
                logger.debug("Application is not running");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void setDefaultTimeZone(TimeZone zone) {
        TimeZone.setDefault(zone);
    }

    public static void setDefaultLocale(Locale locale) {
        Locale.setDefault(locale);
    }

    public static void setDefaultCharset(@NonNull Charset charset) throws IllegalStateException {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        System.setProperty("file.encoding", charset.name());
        try {
            Field defaultCharset = Charset.class.getDeclaredField("defaultCharset");
            defaultCharset.setAccessible(true);
            defaultCharset.set(null, null);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to set default charset", e);
        }
    }

    public static void setDefaultUncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
    }
}

