/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.springframework.util.StringUtils;

public class XWebSecurityExpressionRoot {
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";

    public boolean hasXForwardedFor(HttpServletRequest request, String ipAddress) {
        return new IpAddressMatcher(ipAddress).matches((HttpServletRequest)new ProxyHttpServletRequest(request));
    }

    public boolean hasNoXForwardedFor(HttpServletRequest request) {
        return !StringUtils.hasText((String)new ProxyHttpServletRequest(request).getRemoteAddr());
    }

    protected static class ProxyHttpServletRequest
    extends HttpServletRequestWrapper {
        protected ProxyHttpServletRequest(HttpServletRequest request) {
            super(request);
        }

        public String getRemoteAddr() {
            return this.getHeader(XWebSecurityExpressionRoot.X_FORWARDED_FOR);
        }
    }
}

